package cn.com.duiba.nezha.compute.common.support;

import cn.com.duiba.nezha.compute.api.dto.FeatureDto;
import cn.com.duiba.nezha.compute.api.dto.FeatureIdxDto;
import cn.com.duiba.nezha.compute.common.util.DateUtil;
import cn.com.duiba.nezha.compute.common.util.MyStringUtil2;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by pc on 2017/2/17.
 */
public class FeatureParse {

    public static Map<String, String> getFeatureMap(FeatureDto cf,Long advertId) {

        Map<String, String> retMap = new HashMap<>();
        try {
            if (cf != null) {
                cf.setAdvertId(advertId);

                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));

                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f108001", MyStringUtil2.Long2String(cf.getSlotId()));
                retMap.put("f109001", MyStringUtil2.Long2String(cf.getSlotType()));

                retMap.put("f201001", MyStringUtil2.Long2String(cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());

                retMap.put("f301001", MyStringUtil2.Long2String(cf.getOperatingActivityId()));
                retMap.put("f302001", MyStringUtil2.Long2String(cf.getDuibaActivityId()));
                retMap.put("f303001", MyStringUtil2.Long2String(cf.getDuibaActivityType()));

                retMap.put("f501001", cf.getUa());
                Integer hour = DateUtil.getHour(cf.getCurrentGmtCreateTime());
                retMap.put("f502001", MyStringUtil2.Integer2String(hour));

                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime());
                retMap.put("f502002", MyStringUtil2.Integer2String(weekDay));
                retMap.put("f503001", MyStringUtil2.Long2String(cf.getCityId()));

                // rank 转level
                retMap.put("f601001", MyStringUtil2.Long2String(getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", MyStringUtil2.Long2String(getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", MyStringUtil2.Long2String(getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", MyStringUtil2.Long2String(getRankLevel(cf.getActivityOrderRank())));

                // 计算时间差
                Long orderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", MyStringUtil2.Long2String(orderGmtIntervelLevel));

                // 计算活动时间差
                Long activityOrderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", MyStringUtil2.Long2String(activityOrderGmtIntervelLevel));

                // 计算活动上次计费情况
                Long activityLastChargeStatus = getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", MyStringUtil2.Long2String(activityLastChargeStatus));

                // 计算上次计费情况
                Long lastChargeStatus = getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", MyStringUtil2.Long2String(lastChargeStatus));

                //计算上次与当期活动是否相同
                Long activityChangeStatus = getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", MyStringUtil2.Long2String(activityChangeStatus));


                //
                String crossAppAndAdvertID = ""+cf.getAdvertId()+cf.getAppId();
                retMap.put("cf101201",crossAppAndAdvertID);
                //
                String crossActivityAndAdvertID = ""+cf.getAdvertId()+cf.getOperatingActivityId();
                retMap.put("cf101301",crossActivityAndAdvertID);

            }

        } catch (Exception e) {

        }

        return retMap;
    }


    public static Map<String, String> getFeatureMap(FeatureDto cf) {

        Map<String, String> retMap = new HashMap<>();
        try {
            if (cf != null) {

                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));

                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f108001", MyStringUtil2.Long2String(cf.getSlotId()));
                retMap.put("f109001", MyStringUtil2.Long2String(cf.getSlotType()));

                retMap.put("f201001", MyStringUtil2.Long2String(cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());

                retMap.put("f301001", MyStringUtil2.Long2String(cf.getOperatingActivityId()));
                retMap.put("f302001", MyStringUtil2.Long2String(cf.getDuibaActivityId()));
                retMap.put("f303001", MyStringUtil2.Long2String(cf.getDuibaActivityType()));

                retMap.put("f501001", cf.getUa());
                Integer hour = DateUtil.getHour(cf.getCurrentGmtCreateTime());
                retMap.put("f502001", MyStringUtil2.Integer2String(hour));

                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime());
                retMap.put("f502002", MyStringUtil2.Integer2String(weekDay));
                retMap.put("f503001", MyStringUtil2.Long2String(cf.getCityId()));

                // rank 转level
                retMap.put("f601001", MyStringUtil2.Long2String(getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", MyStringUtil2.Long2String(getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", MyStringUtil2.Long2String(getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", MyStringUtil2.Long2String(getRankLevel(cf.getActivityOrderRank())));

                // 计算时间差
                Long orderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", MyStringUtil2.Long2String(orderGmtIntervelLevel));

                // 计算活动时间差
                Long activityOrderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", MyStringUtil2.Long2String(activityOrderGmtIntervelLevel));

                // 计算活动上次计费情况
                Long activityLastChargeStatus = getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", MyStringUtil2.Long2String(activityLastChargeStatus));

                // 计算上次计费情况
                Long lastChargeStatus = getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", MyStringUtil2.Long2String(lastChargeStatus));

                //计算上次与当期活动是否相同
                Long activityChangeStatus = getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", MyStringUtil2.Long2String(activityChangeStatus));


                //
                String crossAppAndAdvertID = ""+cf.getAdvertId()+cf.getAppId();
                retMap.put("cf101201",crossAppAndAdvertID);
                //
                String crossActivityAndAdvertID = ""+cf.getAdvertId()+cf.getOperatingActivityId();
                retMap.put("cf101301",crossActivityAndAdvertID);

            }

        } catch (Exception e) {

        }

        return retMap;
    }

    public static FeatureIdxDto toFeatureIdxDto(FeatureDto cf) {

        FeatureIdxDto dto = new FeatureIdxDto();
        try {
            if (cf != null) {

                dto.setF101001(MyStringUtil2.Long2String(cf.getAdvertId()));
                dto.setF106001(MyStringUtil2.Long2String(cf.getAccountId()));

                dto.setF108001(MyStringUtil2.Long2String(cf.getSlotId()));
                dto.setF109001(MyStringUtil2.Long2String(cf.getSlotType()));
                dto.setF201001(MyStringUtil2.Long2String(cf.getAppId()));
                dto.setF202001(cf.getAppCategory());


                dto.setF301001(MyStringUtil2.Long2String(cf.getOperatingActivityId()));
                dto.setF302001(MyStringUtil2.Long2String(cf.getDuibaActivityId()));
                dto.setF303001(MyStringUtil2.Long2String(cf.getDuibaActivityType()));


                dto.setF501001(cf.getUa());

                Integer hour = DateUtil.getHour(cf.getCurrentGmtCreateTime());
                dto.setF502001(MyStringUtil2.Integer2String(hour));

                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime());
                dto.setF502002(MyStringUtil2.Integer2String(weekDay));

                dto.setF503001(MyStringUtil2.Long2String(cf.getCityId()));

                // rank 转level
                dto.setF601001(MyStringUtil2.Long2String(getDayRankLevel(cf.getDayOrderRank())));

                dto.setF602001(MyStringUtil2.Long2String(getRankLevel(cf.getOrderRank())));

                dto.setF603001(MyStringUtil2.Long2String(getDayRankLevel(cf.getDayActivityOrderRank())));

                dto.setF604001(MyStringUtil2.Long2String(getRankLevel(cf.getActivityOrderRank())));

                // 计算时间差
                Long orderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                dto.setF605001(MyStringUtil2.Long2String(orderGmtIntervelLevel));

                // 计算活动时间差
                Long activityOrderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                dto.setF606001(MyStringUtil2.Long2String(activityOrderGmtIntervelLevel));

                // 计算活动上次计费情况
                Long activityLastChargeStatus = getChargeStatus(cf.getActivityLastChargeNums());
                dto.setF607001(MyStringUtil2.Long2String(activityLastChargeStatus));

                // 计算上次计费情况
                Long lastChargeStatus = getChargeStatus(cf.getLastChargeNums());
                dto.setF608001(MyStringUtil2.Long2String(lastChargeStatus));

                //计算上次与当期活动是否相同
                Long activityChangeStatus = getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                dto.setF609001(MyStringUtil2.Long2String(activityChangeStatus));

                //
                String crossAppAndAdvertID = ""+cf.getAdvertId()+cf.getAppId();
                dto.setCf101201(crossAppAndAdvertID);
                //
                String crossActivityAndAdvertID = ""+cf.getAdvertId()+cf.getOperatingActivityId();
                dto.setCf101301(crossActivityAndAdvertID);

            }

        } catch (Exception e) {

        }


        return dto;
    }


    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {

        Long ret = null;
        Integer minutes = DateUtil.getIntervalMinutes(date, otherDate);

        if (minutes == null) {
            ret = -1L;
        } else if (minutes <= 5) {
            ret = 1L;
        } else if (minutes <= 10) {
            ret = 2L;
        } else if (minutes <= 30) {
            ret = 3L;
        } else if (minutes <= 60) {
            ret = 4L;
        } else {
            ret = 99L;
        }
        return ret;

    }

    public static Long getDayRankLevel(Long rank) {

        Long ret = null;
        if (rank == null) {
            ret = null;
        } else if (rank <= 7) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getRankLevel(Long rank) {

        Long ret = null;
        if (rank <= 15) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {

        Long ret = null;
        if (chargeNums == null ||chargeNums<1 ) {
            ret = 0L;
        } else {
            ret = 1L;
        }
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {

        Long ret = null;
        if (operatingActivityId == null || lastOperatingActivityId == null) {
            ret = 0L;
        } else if (operatingActivityId.equals(lastOperatingActivityId)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }
}