/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.support;

import cn.com.duiba.nezha.compute.api.dto.FeatureDto;
import cn.com.duiba.nezha.compute.common.enums.DateStyle;
import cn.com.duiba.nezha.compute.common.util.DateUtil;
import cn.com.duiba.nezha.compute.common.util.MyStringUtil2;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FeatureParse {
    public static boolean generateFeatureMapStatic(FeatureDto cf, Map<String, String> retMap) {
        boolean ret = false;
        try {
            if (cf != null) {
                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));
                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f108001", MyStringUtil2.Long2String(cf.getSlotId()));
                retMap.put("f109001", MyStringUtil2.Long2String(cf.getSlotType()));
                retMap.put("f201001", MyStringUtil2.Long2String(cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());
                retMap.put("f301001", MyStringUtil2.Long2String(cf.getOperatingActivityId()));
                retMap.put("f302001", MyStringUtil2.Long2String(cf.getActivityId()));
                retMap.put("f303001", MyStringUtil2.Long2String(cf.getActivityType()));
                retMap.put("f501001", cf.getUa());
                Integer hour = DateUtil.getHour(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS_SSS);
                retMap.put("f502001", MyStringUtil2.Integer2String(hour));
                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS_SSS);
                retMap.put("f502002", MyStringUtil2.Integer2String(weekDay));
                retMap.put("f503001", MyStringUtil2.Long2String(cf.getCityId()));
                retMap.put("f601001", MyStringUtil2.Long2String(FeatureParse.getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", MyStringUtil2.Long2String(FeatureParse.getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", MyStringUtil2.Long2String(FeatureParse.getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", MyStringUtil2.Long2String(FeatureParse.getRankLevel(cf.getActivityOrderRank())));
                Long orderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", MyStringUtil2.Long2String(orderGmtIntervelLevel));
                Long activityOrderGmtIntervelLevel = FeatureParse.getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", MyStringUtil2.Long2String(activityOrderGmtIntervelLevel));
                Long activityLastChargeStatus = FeatureParse.getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", MyStringUtil2.Long2String(activityLastChargeStatus));
                Long lastChargeStatus = FeatureParse.getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", MyStringUtil2.Long2String(lastChargeStatus));
                Long activityChangeStatus = FeatureParse.getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", MyStringUtil2.Long2String(activityChangeStatus));
                String crossAppAndAdvertID = "" + cf.getAdvertId() + cf.getAppId();
                retMap.put("cf101201", crossAppAndAdvertID);
                String crossActivityAndAdvertID = "" + cf.getAdvertId() + cf.getOperatingActivityId();
                retMap.put("cf101301", crossActivityAndAdvertID);
                retMap.put("f504001", cf.getModel());
                retMap.put("f505001", cf.getPriceSection());
                retMap.put("f506001", cf.getConnectionType());
                retMap.put("f507001", cf.getOperatorType());
                retMap.put("f611001", MyStringUtil2.Long2String(cf.getPutIndex()));
                retMap.put("f306001", cf.getActivityUseType());
                retMap.put("f403001", cf.getMemberId());
                retMap.put("f403005", cf.getMobile());
                Long iso = FeatureParse.isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", MyStringUtil2.Long2String(iso));
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean generateFeatureMapDynamic(FeatureDto cf, Map<String, String> retMap) {
        boolean ret = false;
        try {
            if (cf != null) {
                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));
                String crossAppAndAdvertID = "" + cf.getAdvertId() + cf.getAppId();
                retMap.put("cf101201", crossAppAndAdvertID);
                String crossActivityAndAdvertID = "" + cf.getAdvertId() + cf.getOperatingActivityId();
                retMap.put("cf101301", crossActivityAndAdvertID);
                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f111001", cf.getPromoteUrl());
                retMap.put("f102001", cf.getMatchTagNums());
                retMap.put("f801001", cf.getGoodsId());
                retMap.put("f802001", cf.getCatId());
                retMap.put("f802002", cf.getBrandId());
                retMap.put("f803001", MyStringUtil2.Long2String(FeatureParse.getCost(cf.getCost(), cf.getPrice())));
                retMap.put("f803002", MyStringUtil2.Long2String(FeatureParse.getLog(cf.getPrice())));
                retMap.put("f803003", MyStringUtil2.Long2String(FeatureParse.getCost(cf.getViewCount(), cf.getBuyCount())));
                retMap.put("f803004", MyStringUtil2.Long2String(FeatureParse.getLog(cf.getBuyCount())));
                retMap.put("f110001", MyStringUtil2.Long2String(cf.getTimes()));
                Long tagChangeStatus = FeatureParse.getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", MyStringUtil2.Long2String(tagChangeStatus));
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Map<String, String> getFeatureMap(FeatureDto cf) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            FeatureParse.generateFeatureMapStatic(cf, retMap);
            FeatureParse.generateFeatureMapDynamic(cf, retMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retMap;
    }

    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {
        Long ret = null;
        Integer minutes = DateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS_SSS, DateStyle.YYYY_MM_DD_HH_MM_SS_SSS);
        ret = minutes == null ? Long.valueOf(-1L) : (minutes <= 5 ? Long.valueOf(1L) : (minutes <= 10 ? Long.valueOf(2L) : (minutes <= 30 ? Long.valueOf(3L) : (minutes <= 60 ? Long.valueOf(4L) : Long.valueOf(99L)))));
        return ret;
    }

    public static Long getDayRankLevel(Long rank) {
        Long ret = null;
        ret = rank == null ? null : (rank <= 7L ? rank : Long.valueOf(-1L));
        return ret;
    }

    public static Long getRankLevel(Long rank) {
        Long ret = null;
        ret = rank <= 15L ? rank : Long.valueOf(-1L);
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {
        Long ret = null;
        ret = chargeNums == null || chargeNums < 1L ? Long.valueOf(0L) : Long.valueOf(1L);
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {
        Long ret = null;
        ret = operatingActivityId == null || lastOperatingActivityId == null ? Long.valueOf(0L) : (operatingActivityId.equals(lastOperatingActivityId) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {
        Long ret = null;
        ret = matchTagNums == null || lastMatchTagNums == null ? Long.valueOf(0L) : (matchTagNums.equals(lastMatchTagNums) ? Long.valueOf(1L) : Long.valueOf(0L));
        return ret;
    }

    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long ret = 0L;
        Integer dayIntervals = DateUtil.getIntervalDays(userLastlogbigintime, userRegtime);
        if (dayIntervals != null) {
            ret = dayIntervals > 1 ? 1L : 0L;
        }
        return ret;
    }

    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0L) {
            ret = new Double(Math.ceil(((double)price.longValue() + 1.0E-6) / (double)cost.longValue())).intValue();
        }
        return ret;
    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0L) {
            ret = new Double(Math.ceil(FeatureParse.log(lvalue.doubleValue(), 2 / 0))).intValue();
        }
        return ret;
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }
}

