/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.MaterialInfo;
import java.util.ArrayList;

public class BayesianBandit {
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> clicks = new ArrayList();
    private ArrayList<Double> exposures = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    private double decay = 1.0;

    public MaterialInfo selectMaterial(ArrayList<MaterialInfo> materialList, Long appId) {
        this.clear();
        MaterialInfo material = new MaterialInfo();
        double RT_CTR_WEIGHT = 0.3;
        double OBSERVE_INTERVAL = 5.0;
        double DECAY = 0.9995;
        long HIS_DISCOUNT = 2L;
        long HIS_DISCOUNT_THRESH = 1000L;
        this.decay = DECAY;
        this.numMachines = materialList.size();
        for (MaterialInfo m : materialList) {
            double click = 0.0;
            double exposure = 0.0;
            for (Long clk : m.click) {
                click += (double)clk.longValue();
            }
            this.clicks.add(click);
            for (Long exp : m.exposure) {
                exposure += (double)exp.longValue();
            }
            this.exposures.add(exposure);
            if (exposure > 0.0) {
                if (m.lastClick > HIS_DISCOUNT_THRESH) {
                    m.lastClick /= HIS_DISCOUNT;
                    m.lastExposure /= HIS_DISCOUNT;
                }
                if (m.lastClick == 0L) {
                    m.lastClick += (long)click;
                    m.lastExposure += (long)exposure;
                } else if (Math.random() < 1.0 / (1.0 + click)) {
                    m.lastClick += (long)click;
                    m.lastExposure += (long)exposure;
                }
                double rtCtr = exposure > 0.0 ? click * 1.0 / exposure : 0.0;
                double hisCtr = m.lastExposure > 0L ? (double)m.lastClick * 1.0 / (double)m.lastExposure : 0.0;
                double reward = click > 0.0 ? RT_CTR_WEIGHT * rtCtr + (1.0 - RT_CTR_WEIGHT) * hisCtr : hisCtr;
                reward = Math.max(reward, 0.01);
                m.reward = m.reward * this.decay + reward;
                m.count = m.count * this.decay + 1.0;
                m.alpha = 1.0 + m.reward / OBSERVE_INTERVAL;
                m.beta = 1.0 + (m.count - m.reward) / OBSERVE_INTERVAL;
                if (m.beta > 100.0) {
                    m.reward /= 2.0;
                    m.count /= 2.0;
                }
            }
            this.rewards.add(m.reward);
            this.counts.add(m.count);
            this.alphas.add(m.alpha);
            this.betas.add(m.beta);
        }
        int index = this.selectMachine();
        material = materialList.get(index);
        return material;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.clicks = new ArrayList();
        this.exposures = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }
}

