package cn.com.duiba.nezha.compute.common.support;

import cn.com.duiba.nezha.compute.api.dto.FeatureDto;
import cn.com.duiba.nezha.compute.common.enums.DateStyle;
import cn.com.duiba.nezha.compute.common.util.DateUtil;
import cn.com.duiba.nezha.compute.common.util.MyStringUtil2;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by pc on 2017/2/17.
 */
public class FeatureParse {

    public static boolean generateFeatureMapStatic(FeatureDto cf, Map<String, String> retMap) {
        boolean ret = false;

        try {
            if (cf != null) {



                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));

                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                retMap.put("f108001", MyStringUtil2.Long2String(cf.getSlotId()));
                retMap.put("f109001", MyStringUtil2.Long2String(cf.getSlotType()));

                retMap.put("f201001", MyStringUtil2.Long2String(cf.getAppId()));
                retMap.put("f202001", cf.getAppCategory());

                retMap.put("f301001", MyStringUtil2.Long2String(cf.getOperatingActivityId()));
                retMap.put("f302001", MyStringUtil2.Long2String(cf.getActivityId()));
                retMap.put("f303001", MyStringUtil2.Long2String(cf.getActivityType()));

                retMap.put("f501001", cf.getUa());
                Integer hour = DateUtil.getHour(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS_SSS);
                retMap.put("f502001", MyStringUtil2.Integer2String(hour));

                Integer weekDay = DateUtil.getWeekNumber(cf.getCurrentGmtCreateTime(), DateStyle.YYYY_MM_DD_HH_MM_SS_SSS);
                retMap.put("f502002", MyStringUtil2.Integer2String(weekDay));
                retMap.put("f503001", MyStringUtil2.Long2String(cf.getCityId()));

                // rank 转level
                retMap.put("f601001", MyStringUtil2.Long2String(getDayRankLevel(cf.getDayOrderRank())));
                retMap.put("f602001", MyStringUtil2.Long2String(getRankLevel(cf.getOrderRank())));
                retMap.put("f603001", MyStringUtil2.Long2String(getDayRankLevel(cf.getDayActivityOrderRank())));
                retMap.put("f604001", MyStringUtil2.Long2String(getRankLevel(cf.getActivityOrderRank())));

                // 计算时间差
                Long orderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getLastGmtCreateTime());
                retMap.put("f605001", MyStringUtil2.Long2String(orderGmtIntervelLevel));

                // 计算活动时间差
                Long activityOrderGmtIntervelLevel =
                        getOrderGmtIntervelLevel(cf.getCurrentGmtCreateTime(), cf.getActivityLastGmtCreateTime());
                retMap.put("f606001", MyStringUtil2.Long2String(activityOrderGmtIntervelLevel));

                // 计算活动上次计费情况
                Long activityLastChargeStatus = getChargeStatus(cf.getActivityLastChargeNums());
                retMap.put("f607001", MyStringUtil2.Long2String(activityLastChargeStatus));

                // 计算上次计费情况
                Long lastChargeStatus = getChargeStatus(cf.getLastChargeNums());
                retMap.put("f608001", MyStringUtil2.Long2String(lastChargeStatus));

                //计算上次与当期活动是否相同
                Long activityChangeStatus = getActivityChangeStatus(cf.getOperatingActivityId(), cf.getLastOperatingActivityId());
                retMap.put("f609001", MyStringUtil2.Long2String(activityChangeStatus));


                //
                String crossAppAndAdvertID = "" + cf.getAdvertId() + cf.getAppId();
                retMap.put("cf101201", crossAppAndAdvertID);
                //
                String crossActivityAndAdvertID = "" + cf.getAdvertId() + cf.getOperatingActivityId();
                retMap.put("cf101301", crossActivityAndAdvertID);


                // 20170602
                // 设备型号
                retMap.put("f504001", cf.getModel());
                // 设备价格区间
                retMap.put("f505001", cf.getPriceSection());
                // 网络类型（2G，3G，4G）
                retMap.put("f506001", cf.getConnectionType());
                // 运营商（中国联通，中国移动，中国电信）
                retMap.put("f507001", cf.getOperatorType());
                // 发券次序，该用户当日发券次数
                retMap.put("f611001", MyStringUtil2.Long2String(cf.getPutIndex()));
                // 活动来源
                retMap.put("f306001", cf.getActivityUseType());
                // 	会员id  cvr
                retMap.put("f403001", cf.getMemberId());
                // 手机号  cvr
                retMap.put("f403005", cf.getMobile());


                // 是否老用户  注册距离最近登录时间大于1天  cvr
                Long iso = isOld(cf.getUserLastlogbigintime(), cf.getUserRegtime());
                retMap.put("f403004", MyStringUtil2.Long2String(iso));


                ret = true;

            }

        } catch (Exception e) {

        }

        return ret;
    }


    public static boolean generateFeatureMapDynamic(FeatureDto cf, Map<String, String> retMap) {

        boolean ret = false;
        try {
            if (cf != null) {


                // 广告ID
                retMap.put("f101001", MyStringUtil2.Long2String(cf.getAdvertId()));

                //
                String crossAppAndAdvertID = "" + cf.getAdvertId() + cf.getAppId();
                retMap.put("cf101201", crossAppAndAdvertID);
                //
                String crossActivityAndAdvertID = "" + cf.getAdvertId() + cf.getOperatingActivityId();
                retMap.put("cf101301", crossActivityAndAdvertID);

                // 20170602
                // 广告主账号
                retMap.put("f106001", MyStringUtil2.Long2String(cf.getAccountId()));
                // 推广网址
                retMap.put("f111001", cf.getPromoteUrl());
                // 广告特征标签列表 以英文逗号分割
                retMap.put("f102001", cf.getMatchTagNums());
                // 商品id  cvr
                retMap.put("f801001", cf.getGoodsId());
                // 商品类目  cvr
                retMap.put("f802001", cf.getCatId());
                // 商品品牌 cvr
                retMap.put("f802002", cf.getBrandId());
                // 成本价 cvr
                retMap.put("f803001", MyStringUtil2.Long2String(getCost(cf.getCost(), cf.getPrice())));
                // 售卖价 cvr
                retMap.put("f803002", MyStringUtil2.Long2String(getLog(cf.getPrice())));
                // 浏览售卖比 cvr
                retMap.put("f803003", MyStringUtil2.Long2String(getCost(cf.getViewCount(), cf.getBuyCount())));
                //售卖量 cvr
                retMap.put("f803004", MyStringUtil2.Long2String(getLog(cf.getBuyCount())));


                //广告投放次数
                retMap.put("f110001", MyStringUtil2.Long2String(cf.getTimes()));
                //前后两单广告标签是否一致
                Long tagChangeStatus = getLastTagChangeStatus(cf.getMatchTagNums(), cf.getDayLastMatchTagNums());
                retMap.put("f610001", MyStringUtil2.Long2String(tagChangeStatus));

                // 20170728
                // 广告素材ID
                retMap.put("f104001",cf.getMaterialId());
                // 广告素材标签
                retMap.put("f112001",cf.getMaterialTags());

                // 广告描述标签
                retMap.put("f113001",cf.getAdvertTags());


                ret = true;
            }

        } catch (Exception e) {

        }

        return ret;
    }


    public static Map<String, String> getFeatureMap(FeatureDto cf) {

        Map<String, String> retMap = new HashMap<>();
        try {
            generateFeatureMapStatic(cf, retMap);
            generateFeatureMapDynamic(cf, retMap);

        } catch (Exception e) {

        }

        return retMap;
    }


    public static Long getOrderGmtIntervelLevel(String date, String otherDate) {

        Long ret = null;
        Integer minutes = DateUtil.getIntervalMinutes(date, otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS_SSS, DateStyle.YYYY_MM_DD_HH_MM_SS_SSS);

        if (minutes == null) {
            ret = -1L;
        } else if (minutes <= 5) {
            ret = 1L;
        } else if (minutes <= 10) {
            ret = 2L;
        } else if (minutes <= 30) {
            ret = 3L;
        } else if (minutes <= 60) {
            ret = 4L;
        } else {
            ret = 99L;
        }
        return ret;

    }

    public static Long getDayRankLevel(Long rank) {

        Long ret = null;
        if (rank == null) {
            ret = null;
        } else if (rank <= 7) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getRankLevel(Long rank) {

        Long ret = null;
        if (rank <= 15) {
            ret = rank;
        } else {
            ret = -1L;
        }
        return ret;
    }

    public static Long getChargeStatus(Long chargeNums) {

        Long ret = null;
        if (chargeNums == null || chargeNums < 1) {
            ret = 0L;
        } else {
            ret = 1L;
        }
        return ret;
    }

    public static Long getActivityChangeStatus(Long operatingActivityId, Long lastOperatingActivityId) {

        Long ret = null;
        if (operatingActivityId == null || lastOperatingActivityId == null) {
            ret = 0L;
        } else if (operatingActivityId.equals(lastOperatingActivityId)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }


    public static Long getLastTagChangeStatus(String matchTagNums, String lastMatchTagNums) {

        Long ret = null;
        if (matchTagNums == null || lastMatchTagNums == null) {
            ret = 0L;
        } else if (matchTagNums.equals(lastMatchTagNums)) {
            ret = 1L;
        } else {
            ret = 0L;
        }
        return ret;
    }

    /**
     * 是否大于1天
     *
     * @param userLastlogbigintime
     * @param userRegtime
     * @return
     */
    public static Long isOld(Date userLastlogbigintime, Date userRegtime) {
        Long ret = (long)0;

        Integer dayIntervals = DateUtil.getIntervalDays(userLastlogbigintime, userRegtime);

        if (dayIntervals != null) {
            ret = dayIntervals > 1 ? (long) 1 : (long) 0;
        }
        return ret;

    }


    public static Long getCost(Long cost, Long price) {
        Long ret = null;
        if (cost != null && price != null && cost > 0) {
            ret = (long) (new Double(Math.ceil((price + 0.000001) / (cost))).intValue());
        }
        return ret;

    }

    public static Long getLog(Long lvalue) {
        Long ret = null;
        if (lvalue != null && lvalue > 0) {
            ret = (long) (new Double(Math.ceil(log(lvalue.doubleValue(), 2 / 0))).intValue());
        }
        return ret;

    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

}