package cn.com.duiba.nezha.compute.common.model;

import org.apache.avro.generic.GenericData;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;


/**
 * Created by jiali on 2017/6/7.
 */
public class RoiPidController {

    private double P = 0;
    private double I = 0;
    private double D = 0;
    private double F = 0;

    private boolean firstRun=true;
    private double errorSum=0;
    private double lastOutput=0;
    private double lastActual=0;
    private double lastFactor=0;

    private double maxIOutput=0;
    private double maxError=0;
    private double maxOutput=0;
    private double minOutput=0;

    private double outputRampRate=0;
    private double outputFilter=0;

    static class Constant{

        //默认调价因子
        static  double DEFAULT_FACTOR = 1;

        //控制器参数
        static double DEFAULT_P = 0.5;
        static double DEFAULT_I = 0.01;
        static double DEFAULT_D = 0.5;

        //控制器敏感度
        static double SENSITIVITY_DEFAULT = 1.0;
        static double SENSITIVITY_USE = 1.15;
    }

    public RoiPidController(){
        P = Constant.DEFAULT_P;
        I = Constant.DEFAULT_I;
        D = Constant.DEFAULT_D;
        checkSigns();
    }

    public double getSensitivity(double factor, double targetCpa, double budget)
    {
        double senitivity = Constant.SENSITIVITY_DEFAULT;
        if(budget <= 0 || targetCpa <= 0)
            return senitivity;
        if(budget/targetCpa < 30 || targetCpa > 4000 || factor<0.5 || factor > 1.5 )
        {
            senitivity = Constant.SENSITIVITY_USE;
        }
        return senitivity;
    }

    public List<StatInfo> getPriceFactor(List<StatInfo> infos, double targetCpa, double budget)
    {
        List<StatInfo> newInfos = new ArrayList<>();
        HashMap<String,Double> factorMap = new HashMap();

        for (StatInfo info:infos)                           //get valid factor
        {
            if(info.lastSumFee > 0) {
                factorMap.put(info.id,info.factor);
            }
        }

        for(StatInfo info : infos)
        {
            if(info.sumFee - info.lastSumFee > 20 * 100)    //控制规模
            {
                //check & coldstart
                if(!checkDataVolume(info, targetCpa))
                {
                    if(!info.id.contains("DEFAULT")) {
                       continue;
                    }
                }

                //first run init
                if(info.lastSumFee == 0)
                {
                    if(info.id.contains("SLOT"))
                    {
                        String prefix = info.id.split("SLOT")[0];
                        info.factor = factorMap.containsKey(prefix+"DEFAULT") ? factorMap.get(prefix+"DEFAULT") : 1;
                    }
                    else if(info.id.contains("ACTIVITY"))
                    {
                        String prefix = info.id.split("ACTIVITY")[0];
                        info.factor = factorMap.containsKey(prefix+"DEFAULT") ? factorMap.get(prefix+"DEFAULT") : 1;
                        String[] array = info.id.split("_");
                        if(array.length >= 4) {
                            String postfix = array[3];
                            info.factor = factorMap.containsKey(prefix+"APP_"+postfix) ? factorMap.get(prefix+"APP_"+postfix) : info.factor;
                        }
                    }
                    else if(info.id.contains("APP"))
                    {
                        String prefix = info.id.split("APP")[0];

                        info.factor = factorMap.containsKey(prefix+"DEFAULT") ? factorMap.get(prefix+"DEFAULT") : 1;
                    }
                }

                //update
                info.factor = getOnePriceFactor(info, targetCpa, budget);
                info.lastSumFee = info.sumFee;
                info.lastSumConv = info.sumConv;
                newInfos.add(info);
            }
        }
        factorMap.clear();
        return newInfos;
    }

    private double getOnePriceFactor(StatInfo info, double targetCpa, double budget)
    {
        //1、check param
        if(!checkDataVolume(info, targetCpa)) {
            info.factor = 1;
            return info.factor;
        }

        //2、初始化控制器
        reset();
        double actual = info.sumFee / info.sumConv;
        setOutputLimits(targetCpa);
        double senitivity = Constant.SENSITIVITY_DEFAULT;

        //3、计算上一次调控的状态
        if(info.lastSumFee == 0)
        {
            firstRun = true;
        }
        else
        {
            firstRun = false;
        }
        lastFactor = info.factor;
        lastOutput = info.lastSumConv > 0 ? lastFactor * targetCpa - 1 : 0; //近似算法
        lastActual = info.lastSumConv > 0 ? info.lastSumFee / info.lastSumConv : actual;
        maxError = 100;
        errorSum = constrain(info.lastSumConv * targetCpa - info.lastSumFee,-maxError,maxError);//近似算法
        senitivity = getSensitivity(info.factor, targetCpa, budget);

        //4、调控
        double output = getOutput(actual, targetCpa);

        //5、调价因子平滑
        if(output < 0) {
            info.factor = lastFactor * Math.max(1 + output / targetCpa, 0.9 / senitivity);
            if(targetCpa < actual)
                info.factor = Math.max(info.factor, 0.3 * targetCpa/actual);
            else
                info.factor = Math.max(info.factor, 0.3);
        }
        else {
            info.factor = lastFactor * Math.min(1 + output / targetCpa, 1.1 * senitivity);
            if(targetCpa > actual)
                info.factor = Math.min(info.factor, 3 * targetCpa/actual);
            else
                info.factor = Math.min(info.factor, 3);
        }
        return  info.factor;
    }

    private boolean checkDataVolume(StatInfo info, double targetCpa)
    {
        boolean isValid = true;
        if(info.sumFee <= 0 || info.sumConv <=0 || info.lastSumFee < 0 || info.lastSumConv <0 || info.factor <= 0 || targetCpa <= 0)
        {
            isValid = false;
        }

        if(isColdStarting(info.sumFee, info.sumConv, targetCpa))
        {
            isValid = false;
        }

        return isValid;
    }

    private boolean isColdStarting(double sumFee,double sumConv,double targetCpa)
    {
        if(sumFee <= targetCpa * 5 && sumConv <= 3)
            return true;
        return false;
    }

    public double getPriceFactor(double sumFee, double sumConv, double lastSumFee, double lastSumConv, double factor, double targetCpa, double budget)
    {
        //1、check param
        if(sumFee <= 0 || sumConv <=0 || lastSumFee < 0 || lastSumConv <0 || factor <= 0 || targetCpa <= 0)
        {
            return Constant.DEFAULT_FACTOR;
        }

        if(isColdStarting(sumFee,sumConv,targetCpa))
        {
            return Constant.DEFAULT_FACTOR;
        }

        //2、初始化控制器
        reset();
        double actual = sumFee / sumConv;
        setOutputLimits(targetCpa);
        double senitivity = 1;
        //3、计算上一次调控的状态
        if(lastSumFee == 0)
        {
            firstRun = true;
        }
        else
        {
            firstRun = false;
        }
        lastFactor = factor;
        lastOutput = lastSumConv > 0 ? lastFactor * targetCpa - 1 : 0; //近似算法
        lastActual = lastSumConv > 0 ? lastSumFee / lastSumConv : actual;
        maxError = 100;
        errorSum = constrain(lastSumConv * targetCpa - lastSumFee,-maxError,maxError);//近似算法
        senitivity = getSensitivity(factor, targetCpa, budget);

        //4、调控
        double output = getOutput(actual, targetCpa);

        //5、调价因子平滑
        if(output < 0) {
            factor = lastFactor * Math.max(1 + output / targetCpa, 0.9/senitivity);
            if(targetCpa < actual)
                factor = Math.max(factor, 0.5*targetCpa/actual);
            else
                factor = Math.max(factor, 0.5);
        }
        else {
            factor = lastFactor * Math.min(1 + output / targetCpa, 1.1*senitivity);
            if(targetCpa > actual)
                factor = Math.min(factor, 2*targetCpa/actual);
            else
                factor = Math.min(factor, 2);
        }

        return factor;
    }

    private RoiPidController(double p, double i, double d){
        P=p; I=i; D=d;
        checkSigns();
    }

    private RoiPidController(double p, double i, double d, double f){
        P=p; I=i; D=d; F=f;
        checkSigns();
    }

    private void setI(double i){  /*I翻倍，累计错误减半*/
        if(I != 0){
            errorSum = errorSum * I / i;
        }
        if(maxIOutput!=0){
            maxError = maxIOutput / i;
        }
        I = i;
        checkSigns();
    }


    private void setPID(double p, double i, double d){
        P=p;D=d;
        setI(i);    //积分项具有额外的计算，需要专门set
        checkSigns();
    }
    private void setPID(double p, double i, double d,double f){
        P=p;D=d;F=f;
        setI(i);
        checkSigns();
    }

    private void setMaxIOutput(double maximum){
        maxIOutput = maximum;
        if(I!=0){
            maxError = maxIOutput/I;
        }
    }

    private void setOutputLimits(double output){
        setOutputLimits(-output,output);
    }

    private void setOutputLimits(double minimum,double maximum){
        if(maximum < minimum)return;
        maxOutput=maximum;
        minOutput=minimum;

        // Ensure the bounds of the I term are within the bounds of the allowable output swing
        if(maxIOutput==0 || maxIOutput>(maximum-minimum) ){
            setMaxIOutput(maximum-minimum);
        }
    }

    private double getOutput(double actual, double setpoint){
        double output;
        double Poutput;
        double Ioutput;
        double Doutput;
        double Foutput;

        double error = setpoint - actual;

        Foutput = F * setpoint;
        Poutput = P * error;

        if(firstRun){
            lastActual = actual;
            lastOutput = Poutput + Foutput;
            firstRun = false;
        }

        // D：负数，减缓控制系统，防止调整信号突变与超调
        Doutput = - D * (actual - lastActual);
        lastActual = actual;

        // I: 积分项
        // 1. maxIoutput 限制了I项的权重。
        // 2. prevent windup by not increasing errorSum if we're already running against our max Ioutput
        // 3. prevent windup by not increasing errorSum if output is output= maxOutput
        Ioutput = I * errorSum;
        if(maxIOutput != 0){
            Ioutput = constrain(Ioutput, -maxIOutput, maxIOutput);
        }

        output = Foutput + Poutput + Ioutput + Doutput;

        // error平滑
        if(minOutput != maxOutput && !bounded(output, minOutput,maxOutput) ){ //error超出限制重置，让系统更平滑。P充分大，I开始作用。
            errorSum = error;
        }
        else if(outputRampRate!=0 && !bounded(output, lastOutput-outputRampRate,lastOutput+outputRampRate) ){
            errorSum = error;
        }
        else if(maxIOutput!=0){
            errorSum = constrain(errorSum + error,-maxError,maxError);
        }
        else{
            errorSum += error;
        }

        // 控制信号平滑
        if(outputRampRate!=0){
            output = constrain(output, lastOutput - outputRampRate,lastOutput + outputRampRate);
        }
        if(minOutput!=maxOutput){
            output = constrain(output, minOutput,maxOutput);
        }
        if(outputFilter!=0){
            output = lastOutput*outputFilter+output*(1-outputFilter);
        }

        lastOutput = output;
        return output;
    }

    private void reset(){
        firstRun=true;
        errorSum=0;
    }

    private void setOutputRampRate(double rate){
        outputRampRate=rate;
    }


    private void setOutputFilter(double strength){
        if(strength==0 || bounded(strength,0,1)){
            outputFilter=strength;
        }
    }

    private double constrain(double value, double min, double max){
        if(value > max){ return max;}
        if(value < min){ return min;}
        return value;
    }

    private boolean bounded(double value, double min, double max){
        return (min<value) && (value < max);
    }

    private void checkSigns(){
        if(P<0) P *= -1;
        if(I<0) I *= -1;
        if(D<0) D *= -1;
        if(F<0) F *= -1;
    }

    public static void main(String[] args) {
        String test = "11789_0_ACTIVITY_23032_1_1092";
        System.out.print(test.split("_")[3]);


        RoiPidController PID = new RoiPidController();

        StatInfo s1 = new StatInfo();
        s1.id = "11789_0_APP_23032";
        s1.sumFee = 3000;
        s1.sumConv = 20;
        s1.lastSumConv = 1;
        s1.lastSumFee = 800;
        s1.factor = 0.5;

        StatInfo s2 = new StatInfo();
        s2.id = "11789_0_ACTIVITY_23032_1_1092";
        s2.sumFee = 3000;
        s2.sumConv = 0;
        s2.lastSumConv = 0;
        s2.lastSumFee = 0;
        s2.factor = 1;

        List<StatInfo> infos = new ArrayList<>();
        infos.add(s1);
        infos.add(s2);

        double bidOld = 1500;
        double maxConv = 100;
        double targetCpa = 1000;
        double actualCpa = s2.sumFee / s2.sumConv;
        double budget = 30000;

        //System.err.printf("Target\tActual\tFactor\tBid\tsumFee\tsumConv\tlsumFee\tlsumConv\n");

        for (int i = 0; i < 200; i++){

            if (i == 60)
                targetCpa = 3000;

            //PID.getOnePriceFactor(s1,targetCpa,30000);
            double factor = 1;
            double bid = bidOld;
            System.err.printf("%3.2f\t%3.2f\t%3.2f\t%3.2f\t%3.0f\t%3.0f\t%3.0f\t%3.0f\t%3.0f\n", targetCpa, actualCpa, s1.factor,s2.factor, bid, s2.sumFee, s2.sumConv, s2.lastSumFee,s2.lastSumConv);
            List<StatInfo> newinfos = PID.getPriceFactor(infos, targetCpa, budget);

            for(StatInfo newinfo:newinfos)
            {
                if (newinfo.id.equals("11789_0_ACTIVITY_23032_1_1092"))
                {
                    factor = newinfo.factor;
                }
            }

            double random = 1;
            double random1 = Math.random();
            double random2 = Math.random();
            if(random1 > random2)
                random = 1 + random1;
            else
                random = 1 - random2;
            bid = bidOld * factor ;

            bid = Math.max(bid,1);
            bid = Math.min(3000,bid);



            double conv = Math.min(Math.pow(1.5, bid/100), maxConv);
            s2.sumFee += bid * conv;
            s2.sumConv += conv;
            actualCpa =  s2.sumFee / s2.sumConv;
        }
    }


}

