/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.MaterialInfo;
import java.util.ArrayList;
import java.util.HashMap;

public class BayesianBandit {
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    private double decay = 1.0;

    public MaterialInfo selectMaterial(ArrayList<MaterialInfo> materialList, Long appid) {
        double exposure;
        double click;
        this.clear();
        this.decay = Constant.DECAY;
        this.numMachines = materialList.size();
        HashMap<Long, Double> gCtrMap = new HashMap<Long, Double>();
        for (MaterialInfo m : materialList) {
            if (m.appId != -1L) continue;
            click = this.sum(m.click);
            exposure = this.sum(m.exposure);
            if (m.lastClick > (double)Constant.MAX_CLICK) {
                m.lastClick /= (double)Constant.DISCOUNT;
                m.lastExposure /= (double)Constant.DISCOUNT;
            }
            m.lastClick += this.getCtr(exposure, click);
            m.lastExposure += 1.0;
            double gCtr = this.getCtr(m.lastExposure, m.lastClick);
            gCtrMap.put(m.getMaterialId(), gCtr);
        }
        for (MaterialInfo m : materialList) {
            click = this.sum(m.click);
            exposure = this.sum(m.exposure);
            if (exposure > 0.0 && m.appId != -1L) {
                if (m.lastClick == 0.0) {
                    m.reward = 0.0;
                    m.count = 0.0;
                }
                if (m.lastClick > (double)Constant.MAX_CLICK) {
                    m.lastClick /= (double)Constant.DISCOUNT;
                    m.lastExposure /= (double)Constant.DISCOUNT;
                }
                m.lastClick += this.getCtr(exposure, click);
                m.lastExposure += 1.0;
                double rtCtr = this.getCtr(exposure, click);
                double hisCtr = this.getCtr(m.lastExposure, m.lastClick);
                double gCtr = gCtrMap.containsKey(m.getMaterialId()) ? (Double)gCtrMap.get(m.getMaterialId()) : 0.0;
                double confidence = Math.min(m.lastExposure / 500.0, 1.0);
                hisCtr = gCtr;
                double reward = click > 0.0 ? Constant.RT_REWARD_WEIGHT * rtCtr + (1.0 - Constant.RT_REWARD_WEIGHT) * hisCtr : hisCtr;
                reward = Math.max(reward, Constant.MIN_REWARD);
                m.reward = m.reward * this.decay + reward;
                m.count = m.count * this.decay + 1.0;
                m.alpha = 1.0 + m.reward;
                m.beta = 1.0 + (m.count - m.reward);
            }
            this.rewards.add(m.reward);
            this.counts.add(m.count);
            this.alphas.add(m.alpha);
            this.betas.add(m.beta);
        }
        gCtrMap.clear();
        MaterialInfo material = materialList.get(this.selectMachine());
        return material;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(ArrayList<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    static class Constant {
        static double RT_REWARD_WEIGHT = 0.0;
        static double MIN_REWARD = 0.01;
        static long MAX_CLICK = 1000L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

