/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.MaterialInfo;
import java.util.ArrayList;
import java.util.HashMap;

public class BayesianBandit {
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    private double decay = 1.0;

    public MaterialInfo selectMaterial(ArrayList<MaterialInfo> materialList, Long appid) {
        double exposure;
        this.clear();
        this.decay = Constant.DECAY;
        this.numMachines = materialList.size();
        HashMap<Long, Info> mMap = new HashMap<Long, Info>();
        double gSumClk = 0.0;
        double gSumExp = 0.0;
        double gAvgCtr = 0.0;
        double appSumClk = 0.0;
        double appSumExp = 0.0;
        double appAvgCtr = 0.0;
        for (MaterialInfo m : materialList) {
            double click = this.sum(m.click);
            exposure = this.sum(m.exposure);
            if (m.lastClick > (double)Constant.MAX_CLICK) {
                m.lastClick /= (double)Constant.DISCOUNT;
                m.lastExposure /= (double)Constant.DISCOUNT;
            }
            m.lastClick += this.getCtr(exposure, click);
            m.lastExposure += 1.0;
            if (m.appId == -1L) {
                double gCtr = this.getCtr(m.lastExposure, m.lastClick);
                Info info = mMap.containsKey(m.materialId) ? (Info)mMap.get(m.materialId) : new Info();
                info.gctr = gCtr;
                info.gexp = m.lastExposure;
                info.id = m.materialId;
                mMap.put(m.materialId, info);
                gSumClk += m.lastClick;
                gSumExp += m.lastExposure;
                continue;
            }
            double rtCtr = this.getCtr(exposure, click);
            double hisCtr = this.getCtr(m.lastExposure, m.lastClick);
            Info info = mMap.containsKey(m.materialId) ? (Info)mMap.get(m.materialId) : new Info();
            info.hctr = hisCtr;
            info.hexp = m.lastExposure;
            info.rctr = rtCtr;
            info.rexp = exposure;
            info.id = m.materialId;
            mMap.put(m.materialId, info);
            appSumClk = m.lastClick;
            appSumExp += m.lastExposure;
        }
        gAvgCtr = this.getCtr(gSumExp, gSumClk);
        appAvgCtr = this.getCtr(appSumExp, appSumClk);
        double ctrRatio = appSumExp > 100.0 ? this.getCtr(gAvgCtr, appAvgCtr) : 1.0;
        for (MaterialInfo m : materialList) {
            exposure = this.sum(m.exposure);
            if (exposure > 0.0 && m.appId != -1L) {
                double reward = m.lastExposure > 100.0 ? ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).hctr : ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr * ctrRatio;
                reward = Math.max(reward, Constant.MIN_REWARD);
                m.reward = m.reward * this.decay + reward;
                m.count = m.count * this.decay + 1.0;
                m.alpha = 1.0 + m.reward;
                m.beta = 1.0 + (m.count - m.reward);
            }
            this.rewards.add(m.reward);
            this.counts.add(m.count);
            this.alphas.add(m.alpha);
            this.betas.add(m.beta);
        }
        mMap.clear();
        MaterialInfo material = materialList.get(this.selectMachine());
        return material;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(ArrayList<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    class Info {
        long id;
        double gctr;
        double gexp;
        double hctr;
        double hexp;
        double rctr;
        double rexp;
        int rank;
        double reward;

        Info() {
        }
    }

    static class Constant {
        static double RT_REWARD_WEIGHT = 0.0;
        static double MIN_REWARD = 0.01;
        static long MAX_CLICK = 1000L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

