/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.MaterialInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BayesianBandit {
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    private double decay = 1.0;

    public List<MaterialInfo> selectMaterial(ArrayList<MaterialInfo> materialList, Long appid) {
        this.clear();
        this.decay = Constant.DECAY;
        this.numMachines = materialList.size();
        HashMap<Long, Info> mMap = new HashMap<Long, Info>();
        double maxG = 0.01;
        double maxH = 0.01;
        for (MaterialInfo m : materialList) {
            double click = this.sum(m.click);
            double exposure = this.sum(m.exposure);
            if (m.lastClick > (double)Constant.MAX_CLICK) {
                m.lastClick /= (double)Constant.DISCOUNT;
                m.lastExposure /= (double)Constant.DISCOUNT;
            }
            m.lastClick += this.getCtr(exposure, click);
            m.lastExposure += 1.0;
            if (m.appId == -1L) {
                double gCtr = this.getCtr(m.lastExposure, m.lastClick);
                Info info = mMap.containsKey(m.materialId) ? (Info)mMap.get(m.materialId) : new Info();
                maxG = Math.max(gCtr, maxG);
                info.gctr = gCtr;
                info.gexp = m.lastExposure;
                info.id = m.materialId;
                info.gMaterial = m;
                mMap.put(m.materialId, info);
                continue;
            }
            double rtCtr = this.getCtr(exposure, click);
            double hisCtr = this.getCtr(m.lastExposure, m.lastClick);
            Info info = mMap.containsKey(m.materialId) ? (Info)mMap.get(m.materialId) : new Info();
            info.hctr = hisCtr;
            info.hexp = m.lastExposure;
            if (info.hexp > 50.0) {
                maxH = Math.max(hisCtr, maxH);
            }
            info.rctr = rtCtr;
            info.rexp = exposure;
            info.id = m.materialId;
            mMap.put(m.materialId, info);
        }
        for (MaterialInfo m : materialList) {
            double exposure = this.sum(m.exposure);
            if (exposure > 0.0 && m.appId != -1L) {
                double reward = Constant.MIN_REWARD;
                double confidence = m.lastExposure > 100.0 ? 1.0 : m.lastExposure / 100.0;
                reward = (1.0 - confidence) * ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr * 0.5 / maxG + confidence * Math.min(((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).hctr * 0.5 / maxH, 0.5);
                reward = Math.max(reward, Constant.MIN_REWARD);
                if (m.count == 0.0) {
                    m.count = 10.0;
                    m.reward = ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr * 0.5 * m.count / maxG;
                }
                m.reward = m.reward * this.decay + reward;
                m.count = m.count * this.decay + 1.0;
                m.alpha = 1.0 + m.reward;
                m.beta = 1.0 + (m.count - m.reward);
            }
            this.rewards.add(m.reward);
            this.counts.add(m.count);
            this.alphas.add(m.alpha);
            this.betas.add(m.beta);
        }
        MaterialInfo material = materialList.get(this.selectMachine());
        MaterialInfo gMaterial = ((Info)mMap.get((Object)Long.valueOf((long)material.materialId))).gMaterial;
        ArrayList<MaterialInfo> result = new ArrayList<MaterialInfo>();
        result.add(material);
        result.add(gMaterial);
        mMap.clear();
        return result;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(ArrayList<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    class Info {
        long id;
        double gctr;
        double gexp;
        double hctr;
        double hexp;
        double rctr;
        double rexp;
        MaterialInfo gMaterial;

        Info() {
        }
    }

    static class Constant {
        static double RT_REWARD_WEIGHT = 0.0;
        static double MIN_REWARD = 0.01;
        static long MAX_CLICK = 1000L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

