/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.util;

import java.util.Collection;
import java.util.Map;

public class AssertUtil {
    private AssertUtil() {
    }

    public static boolean isAllEmpty(Object ... keys) {
        boolean ret = true;
        for (Object key : keys) {
            if (!AssertUtil.isNotEmpty(key)) continue;
            ret = false;
        }
        return ret;
    }

    public static boolean isAllNotEmpty(Object ... keys) {
        boolean ret = true;
        for (Object key : keys) {
            if (!AssertUtil.isEmpty(key)) continue;
            ret = false;
        }
        return ret;
    }

    public static boolean isAnyEmpty(Object ... keys) {
        boolean ret = false;
        for (Object key : keys) {
            if (!AssertUtil.isEmpty(key)) continue;
            ret = true;
        }
        return ret;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return AssertUtil.isNull(collection) || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return AssertUtil.isNull(map) || map.size() < 1;
    }

    public static boolean isEmpty(Object object) {
        if (object instanceof Collection) {
            return AssertUtil.isEmpty((Collection)object);
        }
        if (object instanceof Map) {
            return AssertUtil.isEmpty((Map)object);
        }
        return AssertUtil.isNull(object) || "".equals(object);
    }

    public static boolean isEmpty(Object[] object) {
        return AssertUtil.isNull(object) || object.length < 1;
    }

    public static boolean isEmpty(String text) {
        return AssertUtil.isNull(text) || text.trim().length() < 1;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !AssertUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !AssertUtil.isEmpty(map);
    }

    public static boolean isNotEmpty(Object object) {
        return !AssertUtil.isEmpty(object);
    }

    public static boolean isNotEmpty(Object[] object) {
        return !AssertUtil.isEmpty(object);
    }

    public static boolean isNotEmpty(String text) {
        return !AssertUtil.isEmpty(text);
    }

    private static boolean isNull(Object object) {
        return object == null;
    }

    private static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean hasLength(String text) {
        return text != null && text.length() > 0;
    }

    public static boolean hasText(String text) {
        if (!AssertUtil.hasLength(text)) {
            return false;
        }
        int strLen = text.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isContain(String textToSearch, String substring) {
        return AssertUtil.hasLength(textToSearch) && AssertUtil.hasLength(substring) && textToSearch.contains(substring);
    }

    public static boolean isAssignable(Class<?> superType, Class<?> subType) {
        return AssertUtil.isNotNull(superType) && AssertUtil.isNotNull(subType) && superType.isAssignableFrom(subType);
    }

    public static boolean isInstanceOf(Class<?> type, Object object) {
        return AssertUtil.isNotNull(type) && type.isInstance(object);
    }
}

