/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.util;

import cn.com.duiba.nezha.compute.common.enums.DateStyle;
import cn.com.duiba.nezha.compute.common.enums.Week;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DateUtil {
    public static String getCurrentTime(DateStyle partition) {
        SimpleDateFormat sdf = new SimpleDateFormat(partition.getValue());
        Date date = new Date();
        return sdf.format(date);
    }

    public static String getTimeString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        return sdf.format(date);
    }

    public static String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        Date date = new Date();
        return sdf.format(date);
    }

    public static Date getCurrentDate() {
        Date date = new Date();
        return date;
    }

    public static String getCurrentTime(String parttern) {
        String pt = DateStyle.YYYY_MM_DD_HH_MM_SS.getValue();
        if (parttern != null) {
            pt = parttern;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pt);
        Date date = new Date();
        return sdf.format(date);
    }

    private static SimpleDateFormat getDateFormat(String parttern) throws RuntimeException {
        if (parttern == null) {
            return new SimpleDateFormat(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue());
        }
        return new SimpleDateFormat(parttern);
    }

    private static int getInteger(Date date, int dateType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(dateType);
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            myDate = DateUtil.addInteger(myDate, dateType, amount);
            dateString = DateUtil.DateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static Date getAccurateDate(List<Long> timestamps) {
        Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                for (int i = 0; i < timestamps.size(); ++i) {
                    for (int j = i + 1; j < timestamps.size(); ++j) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                    }
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                }
                for (int i = 0; i < absoluteValues.size(); ++i) {
                    for (int j = i + 1; j < absoluteValues.size(); ++j) {
                        minAbsoluteValue = (Long)absoluteValues.get(i) > (Long)absoluteValues.get(j) ? ((Long)absoluteValues.get(j)).longValue() : ((Long)absoluteValues.get(i)).longValue();
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.max(timestampsLastTmp[0], timestampsLastTmp[1]);
                    } else if (absoluteValues.size() == 1) {
                        long now;
                        long dateOne = timestampsLastTmp[0];
                        long dateTwo = timestampsLastTmp[1];
                        timestamp = Math.abs(dateOne - dateTwo) < 100000000000L ? Math.max(timestampsLastTmp[0], timestampsLastTmp[1]) : (Math.abs(dateOne - (now = new Date().getTime())) <= Math.abs(dateTwo - now) ? dateOne : dateTwo);
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new Date(timestamp);
        }
        return date;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DateUtil.StringToDate(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (DateStyle style : DateStyle.values()) {
            Date dateTmp = DateUtil.StringToDate(date, style.getValue());
            if (dateTmp == null) continue;
            timestamps.add(dateTmp.getTime());
            map.put(dateTmp.getTime(), style);
        }
        Date retDate = DateUtil.getAccurateDate(timestamps);
        if (retDate != null) {
            dateStyle = (DateStyle)((Object)map.get(retDate.getTime()));
        }
        return dateStyle;
    }

    public static Date StringToDate(String date) {
        DateStyle dateStyle = null;
        return DateUtil.StringToDate(date, dateStyle);
    }

    public static Date StringToDate(String date, String parttern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateUtil.getDateFormat(parttern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date StringToDate(String date, DateStyle dateStyle) {
        Date myDate = null;
        if (dateStyle == null) {
            ArrayList<Long> timestamps = new ArrayList<Long>();
            for (DateStyle style : DateStyle.values()) {
                Date dateTmp = DateUtil.StringToDate(date, style.getValue());
                if (dateTmp == null) continue;
                timestamps.add(dateTmp.getTime());
            }
            myDate = DateUtil.getAccurateDate(timestamps);
        } else {
            myDate = DateUtil.StringToDate(date, dateStyle.getValue());
        }
        return myDate;
    }

    public static String DateToString(Date date, String parttern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateUtil.getDateFormat(parttern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String DateToString(Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateUtil.DateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, String parttern) {
        return DateUtil.StringToString(date, null, parttern);
    }

    public static String StringToString(String date, DateStyle dateStyle) {
        return DateUtil.StringToString(date, null, dateStyle);
    }

    public static String StringToString(String date, String olddParttern, String newParttern) {
        String dateString = null;
        if (olddParttern == null) {
            DateStyle style = DateUtil.getDateStyle(date);
            if (style != null) {
                Date myDate = DateUtil.StringToDate(date, style.getValue());
                dateString = DateUtil.DateToString(myDate, newParttern);
            }
        } else {
            Date myDate = DateUtil.StringToDate(date, olddParttern);
            dateString = DateUtil.DateToString(myDate, newParttern);
        }
        return dateString;
    }

    public static String StringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle == null) {
            DateStyle style = DateUtil.getDateStyle(date);
            if (style != null) {
                dateString = DateUtil.StringToString(date, style.getValue(), newDateStyle.getValue());
            }
        } else {
            dateString = DateUtil.StringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static Date addYear(Date date, int yearAmount) {
        return DateUtil.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int yearAmount) {
        return DateUtil.addInteger(date, 2, yearAmount);
    }

    public static Date addMonth(Date date, int yearAmount) {
        return DateUtil.addInteger(date, 2, yearAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static Date addHour(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int hourAmount) {
        return DateUtil.addInteger(date, 12, hourAmount);
    }

    public static Date addMinute(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 12, hourAmount);
    }

    public static String addSecond(String date, int hourAmount) {
        return DateUtil.addInteger(date, 13, hourAmount);
    }

    public static Date addSecond(Date date, int hourAmount) {
        return DateUtil.addInteger(date, 13, hourAmount);
    }

    public static Integer getYear(String date) {
        Integer year = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            year = DateUtil.getYear(myDate);
        }
        return year;
    }

    public static int getYear(Date date) {
        return DateUtil.getInteger(date, 1);
    }

    public static Integer getMonth(String date) {
        Integer month = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            month = DateUtil.getMonth(myDate);
        }
        return month;
    }

    public static Integer getMonth(Date date) {
        return DateUtil.getInteger(date, 2);
    }

    public static Integer getDay(String date) {
        Integer day = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            day = DateUtil.getDay(myDate);
        }
        return day;
    }

    public static Integer getDay(Date date) {
        return DateUtil.getInteger(date, 5);
    }

    public static Integer getHour(String date) {
        Integer hour = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            hour = DateUtil.getHour(myDate);
        }
        return hour;
    }

    public static Integer getHour(String date, DateStyle dateStyle) {
        Integer hour = null;
        try {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            hour = DateUtil.getHour(myDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hour;
    }

    public static Integer getHour(Date date) {
        return DateUtil.getInteger(date, 11);
    }

    public static Integer getMinute(String date) {
        Integer minute = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            minute = DateUtil.getMinute(myDate);
        }
        return minute;
    }

    public static Integer getMinute(Date date) {
        return DateUtil.getInteger(date, 12);
    }

    public static Integer getSecond(String date) {
        Integer second = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            second = DateUtil.getSecond(myDate);
        }
        return second;
    }

    public static Integer getSecond(Date date) {
        return DateUtil.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateUtil.StringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date) {
        return DateUtil.DateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getTime(String date) {
        return DateUtil.StringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateUtil.DateToString(date, DateStyle.HH_MM_SS);
    }

    public static Week getWeek(String date) {
        Week week = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            week = DateUtil.getWeek(myDate);
        }
        return week;
    }

    public static Week getWeek(Date date) {
        Week week = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                week = Week.SUNDAY;
                break;
            }
            case 1: {
                week = Week.MONDAY;
                break;
            }
            case 2: {
                week = Week.TUESDAY;
                break;
            }
            case 3: {
                week = Week.WEDNESDAY;
                break;
            }
            case 4: {
                week = Week.THURSDAY;
                break;
            }
            case 5: {
                week = Week.FRIDAY;
                break;
            }
            case 6: {
                week = Week.SATURDAY;
            }
        }
        return week;
    }

    public static Integer getWeekNumber(String date, DateStyle dateStyle) {
        Integer weekNumber = null;
        try {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            weekNumber = DateUtil.getWeekNumber(myDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return weekNumber;
    }

    public static Integer getWeekNumber(String date) {
        Integer weekNumber = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateUtil.StringToDate(date, dateStyle);
            weekNumber = DateUtil.getWeekNumber(myDate);
        }
        return weekNumber;
    }

    public static Integer getWeekNumber(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        return weekNumber;
    }

    public static Integer getIntervalDays(String date, String otherDate) {
        return DateUtil.getIntervalDays(DateUtil.StringToDate(date), DateUtil.StringToDate(otherDate));
    }

    public static Integer getIntervalDays(Date date, Date otherDate) {
        if (date == null || otherDate == null) {
            return null;
        }
        date = DateUtil.StringToDate(DateUtil.getDate(date));
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 86400000L);
    }

    public static Integer getIntervalHours(String date, String otherDate) {
        Integer hours = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        DateStyle otherDateStyle = DateUtil.getDateStyle(otherDate);
        if (dateStyle != null && otherDateStyle != null) {
            hours = DateUtil.getIntervalHours(DateUtil.StringToDate(date, dateStyle), DateUtil.StringToDate(otherDate, otherDateStyle));
        }
        return hours;
    }

    public static Integer getIntervalHours(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 3600000L);
    }

    public static Integer getIntervalYears(Date date, Date otherDate) {
        date = DateUtil.StringToDate(DateUtil.getDate(date));
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 86400000L / 365L);
    }

    public static Integer getIntervalYears(String date, String otherDate) {
        Integer years = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        DateStyle otherDateStyle = DateUtil.getDateStyle(otherDate);
        if (dateStyle != null && otherDateStyle != null) {
            years = DateUtil.getIntervalYears(DateUtil.StringToDate(date, dateStyle), DateUtil.StringToDate(otherDate, otherDateStyle));
        }
        return years;
    }

    public static Integer getIntervalMinutes(String date, String otherDate) {
        Integer hours = null;
        DateStyle dateStyle = DateUtil.getDateStyle(date);
        DateStyle otherDateStyle = DateUtil.getDateStyle(otherDate);
        if (dateStyle != null && otherDateStyle != null) {
            hours = DateUtil.getIntervalMinutes(DateUtil.StringToDate(date, dateStyle), DateUtil.StringToDate(otherDate, otherDateStyle));
        }
        return hours;
    }

    public static Integer getIntervalMinutes(String date, String otherDate, DateStyle dateStyle, DateStyle otherDateStyle) {
        Integer ret = null;
        try {
            ret = DateUtil.getIntervalMinutes(DateUtil.StringToDate(date, dateStyle), DateUtil.StringToDate(otherDate, otherDateStyle));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Integer getIntervalMinutes(String date, String otherDate, boolean ignoreDateStyle) {
        Integer ret = null;
        try {
            ret = ignoreDateStyle ? DateUtil.getIntervalMinutes(DateUtil.StringToDate(date, DateStyle.YYYY_MM_DD_HH_MM_SS_SSS), DateUtil.StringToDate(otherDate, DateStyle.YYYY_MM_DD_HH_MM_SS_SSS)) : DateUtil.getIntervalMinutes(date, otherDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static Integer getIntervalMinutes(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 60000L);
    }

    public static String getSubDayString(Date date, int dayInterval) {
        String ret = null;
        try {
            Date otherDate = DateUtil.getSubDay(date, dayInterval);
            ret = DateUtil.getDate(otherDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getSubDayString(String dateStr, int dayInterval) {
        String ret = null;
        try {
            Date otherDate = DateUtil.getSubDay(dateStr, dayInterval);
            ret = DateUtil.getDate(otherDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Date getSubDay(String dateStr, int dayInterval) {
        Date date = DateUtil.StringToDate(dateStr);
        Date ret = DateUtil.getSubDay(date, dayInterval);
        return ret;
    }

    public static Date getSubDay(Date date, int dayInterval) {
        Date ret = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, dayInterval);
            ret = calendar.getTime();
        }
        return ret;
    }

    public static String getSubHourString(String dateStr, int hourInterval) {
        String ret = null;
        try {
            Date otherDate = DateUtil.getSubHour(dateStr, hourInterval);
            ret = DateUtil.getTimeString(otherDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getSubHourString(Date date, int hourInterval) {
        String ret = null;
        try {
            Date otherDate = DateUtil.getSubHour(date, hourInterval);
            ret = DateUtil.getTime(otherDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Date getSubHour(String dateStr, int hourInterval) {
        Date date = DateUtil.StringToDate(dateStr);
        Date ret = DateUtil.getSubHour(date, hourInterval);
        return ret;
    }

    public static Date getSubHour(Date date, int hourInterval) {
        Date ret = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(10, hourInterval);
            ret = calendar.getTime();
        }
        return ret;
    }
}

