/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselect;

import cn.com.duiba.nezha.compute.common.model.activityselect.ActivityInfo;
import cn.com.duiba.nezha.compute.common.model.activityselect.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonPair;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    public static int getCoef(double hisRequest, double request, double hisSend, double send) {
        int coef = 1;
        int i = 1;
        int j = 1;
        if (request < 0.0) {
            for (i = 1; i < 144 && !((request += hisRequest / 144.0) > 0.0); ++i) {
            }
        }
        if (send < 0.0) {
            for (j = 1; j < 144 && !((send += hisSend / 144.0) > 0.0); ++j) {
            }
        }
        return coef += Math.max(i, j);
    }

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> appCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> globalCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        for (ActivityInfo activity : activityInfos) {
            try {
                if (activity.source != 1L || !activity.valid) continue;
                activity.hisSend.globalVal = activity.send.globalVal;
                activity.hisSend.appVal = activity.send.appVal;
                activity.hisSend.slotVal = activity.directSend.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;
                int limit = topn--;
                if (activity.hisRequest.globalVal < 100.0) {
                    if (activityInfos.size() <= limit || !(Math.random() < 1.0E-5)) continue;
                    result.add(activity);
                    continue;
                }
                double slotScore = WilsonInterval.wilsonCalc((long)((long)activity.hisSend.slotVal / 3L), (long)((long)activity.hisRequest.slotVal * 3L)).lowerBound;
                double globalScore = WilsonInterval.wilsonCalc((long)((long)activity.hisSend.globalVal / 3L), (long)((long)activity.hisRequest.globalVal * 3L)).lowerBound;
                double appScore = WilsonInterval.wilsonCalc((long)((long)activity.hisSend.appVal / 3L), (long)((long)activity.hisRequest.appVal * 3L)).lowerBound;
                double coef = 0.0;
                double matchscore = 0.0;
                double sconfidence = Math.min(activity.hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(activity.hisRequest.appVal / 100.0, 1.0);
                double gconfidence = Math.min(activity.hisRequest.globalVal / 1000.0, 1.0);
                matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * 0.7 * Math.max(0.5, gconfidence);
                MatchInfo info = new MatchInfo();
                info.act = activity;
                info.score = matchscore;
                candis.add(info);
                if (!(sconfidence > 0.5)) continue;
                MatchInfo info2 = new MatchInfo();
                info2.act = activity;
                info2.score = slotScore;
                slotCandis.add(info2);
            }
            catch (Exception e) {
                logger.error("error, act:{}", (Object)JSON.toJSONString((Object)activity));
            }
        }
        HashSet<Long> idset = new HashSet<Long>();
        int size1 = slotCandis.size();
        for (int i = 0; i < 20 && i < size1; ++i) {
            ActivityInfo act = ((MatchInfo)slotCandis.poll()).act;
            result.add(act);
            idset.add(act.activityId);
        }
        int size = candis.size();
        for (int i = 0; i < topn && i < size; ++i) {
            ActivityInfo act = ((MatchInfo)candis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
        }
        if (result.size() < topn) {
            int count = topn;
            for (ActivityInfo activity : activityInfos) {
                if (activity.source != 1L || !activity.valid || idset.contains(activity.activityId)) continue;
                idset.add(activity.activityId);
                activity.hisSend.globalVal = activity.send.globalVal;
                activity.hisSend.appVal = activity.send.appVal;
                activity.hisSend.slotVal = activity.directSend.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;
                result.add(activity);
                if (++count < topn) continue;
                break;
            }
        }
        return result;
    }

    public static ActivityInfo select(List<ActivityInfo> activityInfos) {
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<ActivityInfo> candiList = new ArrayList<ActivityInfo>();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        ActivityInfo result = new ActivityInfo();
        try {
            List<ActivityInfo> matchActivityInfos = ActivitySelector.match(activityInfos, Constant.SEARANK_TOPN);
            size = matchActivityInfos.size();
            for (ActivityInfo act : matchActivityInfos) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(act.activityId) ? (RankInfo)mMap.get(act.activityId) : new RankInfo();
                info.grpm = grpm = act.hisRequest.globalVal > 0.0 ? act.hisSend.globalVal / act.hisRequest.globalVal : 0.0;
                info.gexp = act.hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = act.hisRequest.appVal > 0.0 ? act.hisSend.appVal / act.hisRequest.appVal : 0.0;
                info.aexp = act.hisRequest.appVal;
                if (info.hexp > 50.0) {
                    maxA = Math.max(arpm, maxA);
                }
                info.hrpm = hrpm = act.hisRequest.slotVal > 0.0 ? act.hisSend.slotVal / act.hisRequest.slotVal : 0.0;
                info.hexp = act.hisRequest.slotVal;
                if (info.hexp > 50.0) {
                    maxH = Math.max(hrpm, maxH);
                }
                mMap.put(act.activityId, info);
            }
            for (ActivityInfo act : matchActivityInfos) {
                if (act.request.globalVal > 0.0) {
                    double reward = Constant.MIN_REWARD;
                    double sconfidence = Math.min(act.hisRequest.slotVal / 50.0, 1.0);
                    double aconfidence = Math.min(act.hisRequest.appVal / 50.0, 1.0);
                    reward = sconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm * 0.5, maxG, 0.6);
                    reward *= Math.sqrt(reward);
                    reward = Math.max(reward, Constant.MIN_REWARD);
                    act.reward = act.reward * decay + reward;
                    act.count = act.count * decay + 1.0;
                    long oneday = 86400000L;
                    if ((sconfidence > 0.99 || System.currentTimeMillis() - act.updateTime > oneday) && (act.reward / act.count < 0.6 * reward || act.reward / act.count > 1.6 * reward)) {
                        act.reward = 10.0 * reward;
                        act.count = 10.0;
                    }
                    act.alpha = 1.5 + act.reward;
                    act.beta = 2.0 + (act.count - act.reward);
                }
                rewards.add(act.reward);
                counts.add(act.count);
                alphas.add(act.alpha);
                betas.add(act.beta);
                candiList.add(act);
            }
            int numMachines = candiList.size();
            result = (ActivityInfo)candiList.get(ActivitySelector.selectMachine(alphas, betas, numMachines));
            if (System.currentTimeMillis() - result.updateTime > 60000L) {
                result.isUpdate = true;
            }
            mMap.clear();
            result.lastRequest.appVal = result.request.appVal;
            result.lastRequest.slotVal = result.request.slotVal;
            result.lastRequest.globalVal = result.request.globalVal;
            result.lastSend.appVal = result.send.appVal;
            result.lastSend.slotVal = result.send.slotVal;
            result.lastSend.globalVal = result.send.globalVal;
            return result;
        }
        catch (Exception e) {
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString(activityInfos)});
            return result;
        }
    }

    public static void print(ActivityInfo act) {
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.request.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("send = " + act.send.slotVal + "\t" + act.send.appVal + "\t" + act.send.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastSend = " + act.lastSend.slotVal + "\t" + act.lastSend.appVal + "\t" + act.lastSend.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
        System.out.println("hisSend = " + act.hisSend.slotVal + "\t" + act.hisSend.appVal + "\t" + act.hisSend.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 40;

        Constant() {
        }
    }
}

