/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.pacing.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonPair;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pacing {
    private static final Logger logger = LoggerFactory.getLogger(Pacing.class);

    public boolean check() {
        return true;
    }

    public boolean pacing(Long advertId, Integer type, Long fee, Double factor, CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo, Boolean isDollMachine) {
        boolean isGiveUp = false;
        if (type == 2 && !isDollMachine.booleanValue()) {
            boolean isRisk;
            Double competence = this.competence(cvrInfo, ctrInfo, clkInfo, timeInfo);
            Double priceScore = this.priceScore(type, fee, factor, clkInfo, timeInfo);
            Double prob = competence * priceScore;
            double risk = this.risk(cvrInfo, ctrInfo, clkInfo, timeInfo);
            boolean bl = isRisk = Math.random() < risk;
            if (!isRisk) {
                boolean bl2 = isGiveUp = Math.random() > competence;
            }
            if (!isGiveUp) {
                boolean bl3 = isGiveUp = Math.random() > priceScore;
            }
            if (Math.random() < 5.0E-4 && isGiveUp) {
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{advertId, isGiveUp, competence, priceScore, risk});
            } else if (Math.random() < 5.0E-5 && !isGiveUp) {
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{advertId, isGiveUp, competence, priceScore, risk});
            }
        }
        if (isDollMachine.booleanValue()) {
            double hourConvert = clkInfo.g1h * cvrInfo.getCvrInfo().g1h;
            double maxConvert = 2600.0;
            Calendar calendar = Calendar.getInstance();
            int minutes = calendar.get(12);
            double speed = 0.0;
            if (minutes > 0 && (speed = hourConvert / (double)minutes) > 0.001) {
                double p = maxConvert / (speed * 60.0);
                p *= p;
                boolean bl = isGiveUp = Math.random() > p;
                if (hourConvert > maxConvert) {
                    isGiveUp = true;
                }
            }
            if (Math.random() < 0.001) {
                logger.info("pacing advertId:{} convert:{} giveup:{} speed:{}", new Object[]{advertId, hourConvert, isGiveUp, speed});
            }
        }
        return isGiveUp;
    }

    public double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double competenceGlobal;
        double app7dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.app7d, clkInfo.app7d);
        double app1dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.app1d, clkInfo.app1d);
        double app1hCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.app1h, clkInfo.app1h);
        double global7dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.g7d, clkInfo.g7d);
        double global1dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.g1d, clkInfo.g1d);
        double global1hCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.g1h, clkInfo.g1h);
        double cvr = cvrInfo.cvr;
        double coefApp = 0.7 * Math.ceil(app7dCvr) + 0.21 * Math.ceil(app1dCvr) + 0.09 * Math.ceil(app1hCvr);
        double coefGlobal = 0.7 * Math.ceil(global7dCvr) + 0.21 * Math.ceil(global1dCvr) + 0.09 * Math.ceil(global1hCvr);
        double competenceApp = coefApp > 0.0 ? coefApp * cvr / (0.7 * app7dCvr + 0.21 * app1dCvr + 0.09 * app1hCvr) : 1.0;
        double d = competenceGlobal = coefGlobal > 0.0 ? coefGlobal * cvr / (0.7 * global7dCvr + 0.21 * global1dCvr + 0.09 * global1hCvr) : 1.0;
        if (competenceGlobal < 0.3 || competenceApp < 0.7 && competenceGlobal < 0.5) {
            return competenceGlobal;
        }
        return 1.0;
    }

    public double risk(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double budget;
        double coefApp;
        double risk = 0.0;
        double app7dCtr = this.wilsonRoofRight(clkInfo.app7d, ctrInfo.ctrInfo.app7d);
        double app1dCtr = this.wilsonRoofRight(clkInfo.app1d, ctrInfo.ctrInfo.app1d);
        double app1hCtr = this.wilsonRoofRight(clkInfo.app1h, ctrInfo.ctrInfo.app1h);
        double global7dCtr = this.wilsonRoofRight(clkInfo.g7d, ctrInfo.ctrInfo.g7d);
        double global1dCtr = this.wilsonRoofRight(clkInfo.g1d, ctrInfo.ctrInfo.g1d);
        double global1hCtr = this.wilsonRoofRight(clkInfo.g1h, ctrInfo.ctrInfo.g1h);
        double ctr = ctrInfo.ctr;
        double d = 0.7 * app7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * app1dCtr > 0.0 ? 1.0 : (coefApp = 0.0 + 0.09 * app1hCtr > 0.0 ? 1.0 : 0.0));
        double coefGlobal = 0.7 * global7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * global1dCtr > 0.0 ? 1.0 : (0.0 + 0.09 * global1hCtr > 0.0 ? 1.0 : 0.0));
        double competenceApp = coefApp * ctr / (0.7 * app7dCtr + 0.21 * app1dCtr + 0.09 * app1hCtr);
        double competenceGlobal = coefGlobal * ctr / (0.7 * global7dCtr + 0.21 * global1dCtr + 0.09 * global1hCtr);
        if (competenceGlobal > 1.0) {
            risk = 1.0;
        }
        if ((budget = timeInfo.packageBudget.doubleValue()) <= 0.0) {
            risk = 1.0;
        }
        return risk;
    }

    public double priceScore(int type, Long fee, Double factor, StatInfo clkInfo, TimeInfo timeInfo) {
        double cpc;
        double confidence = 0.0;
        double fee1d = 0.0;
        double clk1d = 0.0;
        for (double fee1h : timeInfo.hourFee) {
            if (fee1h == -1.0) continue;
            fee1d += fee1h;
        }
        for (double clk1h : timeInfo.hourClk) {
            if (clk1d == -1.0) continue;
            clk1d += clk1h;
        }
        double d = cpc = clk1d > 0.0 ? fee1d / clk1d : 50.0;
        if (cpc >= 20.0) {
            double feeOri;
            double d2 = feeOri = factor != 0.0 ? (double)fee.longValue() / factor : (double)fee.longValue();
            if (fee <= 10L) {
                return 0.1 * (double)fee.longValue() / 10.0;
            }
            if (fee > 10L && fee <= 15L && feeOri < 20.0) {
                return 0.5;
            }
        }
        return 1.0;
    }

    public class TimeInfo {
        List<Double> hourCtr;
        List<Double> hourCvr;
        List<Double> hourClk;
        List<Double> hourExp;
        List<Double> hourFee;
        List<Double> hourBudgetFee;
        List<Double> hourBudgetExp;
        Double packageBudget;

        public void setHourBudgetExp(List<Double> hourBudgetExp) {
            this.hourBudgetExp = hourBudgetExp;
        }

        public void setHourBudgetFee(List<Double> hourBudgetFee) {
            this.hourBudgetFee = hourBudgetFee;
        }

        public void setHourExp(List<Double> hourExp) {
            this.hourExp = hourExp;
        }

        public void setPackageBudget(Double packageBudget) {
            this.packageBudget = packageBudget;
        }

        public void setHourClk(List<Double> hourClk) {
            this.hourClk = hourClk;
        }

        public void setHourCtr(List<Double> hourCtr) {
            this.hourCtr = hourCtr;
        }

        public void setHourCvr(List<Double> hourCvr) {
            this.hourCvr = hourCvr;
        }

        public Double getPackageBudget() {
            return this.packageBudget;
        }

        public List<Double> getHourBudgetExp() {
            return this.hourBudgetExp;
        }

        public List<Double> getHourBudgetFee() {
            return this.hourBudgetFee;
        }

        public List<Double> getHourExp() {
            return this.hourExp;
        }

        public List<Double> getHourClk() {
            return this.hourClk;
        }

        public List<Double> getHourCtr() {
            return this.hourCtr;
        }

        public List<Double> getHourCvr() {
            return this.hourCvr;
        }

        public void setHourFee(List<Double> hourFee) {
            this.hourFee = hourFee;
        }

        public List<Double> getHourFee() {
            return this.hourFee;
        }
    }

    public class CtrInfo {
        Double ctr;
        StatInfo ctrInfo;

        public void setCtr(Double ctr) {
            this.ctr = ctr;
        }

        public void setCtrInfo(StatInfo ctrInfo) {
            this.ctrInfo = ctrInfo;
        }

        public Double getCtr() {
            return this.ctr;
        }

        public StatInfo getCtrInfo() {
            return this.ctrInfo;
        }
    }

    public class CvrInfo {
        Double cvr;
        StatInfo cvrInfo;

        public void setCvr(Double cvr) {
            this.cvr = cvr;
        }

        public void setCvrInfo(StatInfo cvrInfo) {
            this.cvrInfo = cvrInfo;
        }

        public Double getCvr() {
            return this.cvr;
        }

        public StatInfo getCvrInfo() {
            return this.cvrInfo;
        }
    }

    public class StatInfo {
        Double app1h;
        Double app1d;
        Double app7d;
        Double g1h;
        Double g1d;
        Double g7d;

        public void setApp1d(Double app1d) {
            this.app1d = app1d;
        }

        public void setApp1h(Double app1h) {
            this.app1h = app1h;
        }

        public void setApp7d(Double app7d) {
            this.app7d = app7d;
        }

        public void setG1d(Double g1d) {
            this.g1d = g1d;
        }

        public void setG1h(Double g1h) {
            this.g1h = g1h;
        }

        public void setG7d(Double g7d) {
            this.g7d = g7d;
        }

        public Double getApp1d() {
            return this.app1d;
        }

        public Double getApp1h() {
            return this.app1h;
        }

        public Double getApp7d() {
            return this.app7d;
        }

        public Double getG1d() {
            return this.g1d;
        }

        public Double getG1h() {
            return this.g1h;
        }

        public Double getG7d() {
            return this.g7d;
        }
    }
}

