/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.pacing.AdInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.CtrInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.CvrInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.StatInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.TimeInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.pacing.WilsonPair;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pacing {
    private static final Logger logger = LoggerFactory.getLogger(Pacing.class);

    public boolean checkParam() {
        return true;
    }

    public boolean pacing(AdInfo adInfo, CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        boolean isGiveUp = false;
        boolean isWarn = false;
        Status stat = Status.unkown;
        if (adInfo.type == 2 && !adInfo.isDollMachine.booleanValue() && !adInfo.isWeakFilted.booleanValue()) {
            stat = Status.ocpc_normal;
        } else if (adInfo.isDollMachine.booleanValue() && !adInfo.isWeakFilted.booleanValue()) {
            stat = Status.dollmachine;
        } else if (adInfo.isWeakFilted.booleanValue()) {
            stat = Status.automatch;
        }
        switch (stat) {
            case ocpc_normal: {
                boolean isRisk;
                Double competence = this.competence(cvrInfo, ctrInfo, clkInfo, timeInfo);
                Double priceScore = this.priceScore(adInfo.type, adInfo.fee, adInfo.factor, clkInfo, timeInfo);
                Double prob = competence * priceScore;
                double risk = this.risk(cvrInfo, ctrInfo, clkInfo, timeInfo);
                boolean bl = isRisk = Math.random() < risk;
                if (!isRisk) {
                    boolean bl2 = isGiveUp = Math.random() > competence;
                }
                if (!isGiveUp) {
                    boolean bl3 = isGiveUp = Math.random() > priceScore;
                }
                if (Math.random() < 1.0E-4 && isGiveUp) {
                    logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                    break;
                }
                if (!(Math.random() < 1.0E-5) || isGiveUp) break;
                logger.info("pacing advertId:{} giveup:{} competence:{} pricescore:{} risk:{}", new Object[]{adInfo.advertId, isGiveUp, competence, priceScore, risk});
                break;
            }
            case dollmachine: {
                double hourConvert = clkInfo.g1h * cvrInfo.getCvrInfo().g1h;
                double maxConvert = 9000.0;
                Calendar calendar = Calendar.getInstance();
                int minutes = calendar.get(12);
                double speed = 0.0;
                if (minutes > 0 && (speed = hourConvert / (double)minutes) > 0.001) {
                    double p = maxConvert * 0.7 / (speed * 60.0);
                    p *= p;
                    boolean bl = isGiveUp = Math.random() > p;
                    if (hourConvert >= maxConvert) {
                        isGiveUp = true;
                    }
                }
                if (Math.random() < 5.0E-4) {
                    logger.info("pacing advertId:{} convert:{} giveup:{} speed:{}", new Object[]{adInfo.advertId, hourConvert, isGiveUp, speed});
                }
                if (!(Math.random() < 5.0E-4) || !isWarn) break;
                logger.info("wawaji exceed limit warn");
                break;
            }
            case automatch: {
                boolean isTrace;
                boolean bl = isTrace = cvrInfo.cvrInfo.g7d > 0.0;
                if (isTrace) {
                    if (cvrInfo.cvr > 2.0 * cvrInfo.cvrInfo.g1d) {
                        isGiveUp = false;
                    }
                } else if (adInfo.isWeakFilted.booleanValue() && cvrInfo.competerCvrInfo.app1d > 3.0 * cvrInfo.competerCvrInfo.g1d) {
                    isGiveUp = false;
                }
                if (isGiveUp) break;
                double dayConvert = clkInfo.g1d * cvrInfo.getCvrInfo().g1d;
                if (!(Math.random() < 0.01)) break;
                logger.info("automatch advertId:{} convert:{}", (Object)adInfo.advertId, (Object)dayConvert);
            }
        }
        return isGiveUp;
    }

    public double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    public double competence(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double competenceGlobal;
        double app7dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.app7d, clkInfo.app7d);
        double app1dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.app1d, clkInfo.app1d);
        double app1hCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.app1h, clkInfo.app1h);
        double global7dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.g7d, clkInfo.g7d);
        double global1dCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.g1d, clkInfo.g1d);
        double global1hCvr = this.wilsonRoofLeft(cvrInfo.cvrInfo.g1h, clkInfo.g1h);
        double cvr = cvrInfo.cvr;
        double coefApp = 0.7 * Math.ceil(app7dCvr) + 0.21 * Math.ceil(app1dCvr) + 0.09 * Math.ceil(app1hCvr);
        double coefGlobal = 0.7 * Math.ceil(global7dCvr) + 0.21 * Math.ceil(global1dCvr) + 0.09 * Math.ceil(global1hCvr);
        double competenceApp = coefApp > 0.0 ? coefApp * cvr / (0.7 * app7dCvr + 0.21 * app1dCvr + 0.09 * app1hCvr) : 1.0;
        double d = competenceGlobal = coefGlobal > 0.0 ? coefGlobal * cvr / (0.7 * global7dCvr + 0.21 * global1dCvr + 0.09 * global1hCvr) : 1.0;
        if (competenceGlobal < 0.3 || competenceApp < 0.7 && competenceGlobal < 0.5) {
            return competenceGlobal;
        }
        return 1.0;
    }

    public double risk(CvrInfo cvrInfo, CtrInfo ctrInfo, StatInfo clkInfo, TimeInfo timeInfo) {
        double budget;
        double coefApp;
        double risk = 0.0;
        double app7dCtr = this.wilsonRoofRight(clkInfo.app7d, ctrInfo.ctrInfo.app7d);
        double app1dCtr = this.wilsonRoofRight(clkInfo.app1d, ctrInfo.ctrInfo.app1d);
        double app1hCtr = this.wilsonRoofRight(clkInfo.app1h, ctrInfo.ctrInfo.app1h);
        double global7dCtr = this.wilsonRoofRight(clkInfo.g7d, ctrInfo.ctrInfo.g7d);
        double global1dCtr = this.wilsonRoofRight(clkInfo.g1d, ctrInfo.ctrInfo.g1d);
        double global1hCtr = this.wilsonRoofRight(clkInfo.g1h, ctrInfo.ctrInfo.g1h);
        double ctr = ctrInfo.ctr;
        double d = 0.7 * app7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * app1dCtr > 0.0 ? 1.0 : (coefApp = 0.0 + 0.09 * app1hCtr > 0.0 ? 1.0 : 0.0));
        double coefGlobal = 0.7 * global7dCtr > 0.0 ? 1.0 : (0.0 + 0.21 * global1dCtr > 0.0 ? 1.0 : (0.0 + 0.09 * global1hCtr > 0.0 ? 1.0 : 0.0));
        double competenceApp = coefApp * ctr / (0.7 * app7dCtr + 0.21 * app1dCtr + 0.09 * app1hCtr);
        double competenceGlobal = coefGlobal * ctr / (0.7 * global7dCtr + 0.21 * global1dCtr + 0.09 * global1hCtr);
        if (competenceGlobal > 1.0) {
            risk = 1.0;
        }
        if ((budget = timeInfo.packageBudget.doubleValue()) <= 0.0) {
            risk = 1.0;
        }
        return risk;
    }

    public double priceScore(int type, Long fee, Double factor, StatInfo clkInfo, TimeInfo timeInfo) {
        double cpc;
        double confidence = 0.0;
        double fee1d = 0.0;
        double clk1d = 0.0;
        for (double fee1h : timeInfo.hourFee) {
            if (fee1h == -1.0) continue;
            fee1d += fee1h;
        }
        for (double clk1h : timeInfo.hourClk) {
            if (clk1d == -1.0) continue;
            clk1d += clk1h;
        }
        double d = cpc = clk1d > 0.0 ? fee1d / clk1d : 50.0;
        if (cpc >= 20.0) {
            double feeOri;
            double d2 = feeOri = factor != 0.0 ? (double)fee.longValue() / factor : (double)fee.longValue();
            if (fee <= 10L) {
                return 0.1 * (double)fee.longValue() / 10.0;
            }
            if (fee > 10L && fee <= 15L && feeOri < 20.0) {
                return 0.5;
            }
        }
        return 1.0;
    }

    public static enum Status {
        ocpc_normal,
        dollmachine,
        automatch,
        unkown;

    }
}

