/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselectconversion;

import cn.com.duiba.nezha.compute.common.model.activityselectconversion.ActivityData;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.ActivityInfo;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.ActivityInfoAd;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.ActivityInfoData;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.ActivityInfoModel;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.ActivityModel;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.Advert;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.Val;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.activityselectconversion.WilsonPair;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    public static int getCoef(double hisRequest, double request, double hisClick, double click) {
        int coef = 1;
        int i = 1;
        int j = 1;
        if (request < 0.0) {
            for (i = 1; i < 144 && !((request += hisRequest / 144.0) > 0.0); ++i) {
            }
        }
        if (click < 0.0) {
            for (j = 1; j < 144 && !((click += hisClick / 144.0) > 0.0); ++j) {
            }
        }
        return coef += Math.max(i, j);
    }

    private static List<ActivityInfoModel> sortByIdAndSourceModel(List<ActivityInfoModel> acts) {
        List<ActivityInfoModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoModel>(){

            @Override
            public int compare(ActivityInfoModel act1, ActivityInfoModel act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts) {
        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>(){

            @Override
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityInfoAd> sortByIdAndSourceAd(List<ActivityInfoAd> acts) {
        List<ActivityInfoAd> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoAd>(){

            @Override
            public int compare(ActivityInfoAd act1, ActivityInfoAd act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityModel> sortByIdAndSourceModelBack(List<ActivityModel> acts) {
        List<ActivityModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityModel>(){

            @Override
            public int compare(ActivityModel act1, ActivityModel act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    private static List<ActivityData> sortByIdAndSourceDataBack(List<ActivityData> acts) {
        List<ActivityData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityData>(){

            @Override
            public int compare(ActivityData act1, ActivityData act2) {
                if (act1.activityId > act2.activityId) {
                    return -1;
                }
                return 1;
            }
        });
        return actCopy;
    }

    public static List<ActivityInfoModel> match(List<ActivityInfoModel> actModel, List<ActivityInfoData> actData, List<ActivityInfoAd> actAd) {
        int topn = Constant.SEARANK_TOPN;
        ArrayList<ActivityInfoModel> result = new ArrayList<ActivityInfoModel>();
        ArrayList<ActivityInfoModel> actModelCopy = new ArrayList<ActivityInfoModel>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> appCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        PriorityQueue<MatchInfo> globalCandis = new PriorityQueue<MatchInfo>(actData.size(), iComparator);
        List<ActivityInfoData> actDataCopy = ActivitySelector.sortByIdAndSourceData(actData);
        HashMap<Long, ActivityInfoAd> adHashMap = new HashMap<Long, ActivityInfoAd>();
        for (int i = 0; i < actAd.size(); ++i) {
            adHashMap.put(actAd.get((int)i).activityId, actAd.get(i));
        }
        long size_act = actDataCopy.size();
        int i = 0;
        while ((long)i < size_act) {
            try {
                ActivityInfoModel actM = new ActivityInfoModel();
                actM.activityId = actDataCopy.get((int)i).activityId;
                actM.slotId = actDataCopy.get((int)i).slotId;
                actM.appId = actDataCopy.get((int)i).appId;
                actM.hisClick = new Val();
                actM.hisClick.globalVal = actDataCopy.get((int)i).click.globalVal;
                actM.hisClick.appVal = actDataCopy.get((int)i).click.appVal;
                actM.hisClick.slotVal = actDataCopy.get((int)i).click.slotVal;
                actM.hisCost = new Val();
                actM.hisCost.globalVal = actDataCopy.get((int)i).cost.globalVal;
                actM.hisCost.appVal = actDataCopy.get((int)i).cost.appVal;
                actM.hisCost.slotVal = actDataCopy.get((int)i).cost.slotVal;
                actM.hisRequest = new Val();
                actM.hisRequest.globalVal = actDataCopy.get((int)i).request.globalVal;
                actM.hisRequest.appVal = actDataCopy.get((int)i).request.appVal;
                actM.hisRequest.slotVal = actDataCopy.get((int)i).request.slotVal;
                actModelCopy.add(actM);
                int limit = topn--;
                if (actM.hisRequest.globalVal < 100.0) {
                    if (System.currentTimeMillis() - actDataCopy.get((int)i).createTime < 259200000L) {
                        if (Math.random() < 1.0E-4) {
                            result.add(actM);
                        }
                    } else if (actDataCopy.size() > limit && Math.random() < 1.0E-5) {
                        result.add(actM);
                        --topn;
                    }
                } else {
                    MatchInfo info2;
                    double slotScore = WilsonInterval.wilsonCalc((long)((long)actM.hisClick.slotVal), (long)((long)actM.hisRequest.slotVal * 3L)).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long)((long)actM.hisClick.globalVal), (long)((long)actM.hisRequest.globalVal * 3L)).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long)((long)actM.hisClick.appVal), (long)((long)actM.hisRequest.appVal * 3L)).lowerBound;
                    double coef = 0.0;
                    double matchscore = 0.0;
                    double sconfidence = Math.min(actM.hisRequest.slotVal / 100.0, 1.0);
                    double aconfidence = Math.min(actM.hisRequest.appVal / 100.0, 1.0);
                    double gconfidence = Math.min(actM.hisRequest.globalVal / 1000.0, 1.0);
                    matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                    double changeScore = 0.0;
                    if (adHashMap.containsKey(actDataCopy.get((int)i).activityId)) {
                        changeScore = ActivitySelector.calChangeScore(((ActivityInfoAd)adHashMap.get(actDataCopy.get((int)i).activityId)).getAdverts());
                    }
                    actM.changeScore = changeScore;
                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;
                    candis.add(info);
                    if (sconfidence > 0.99 || actM.hisClick.slotVal > 5.0) {
                        info2 = new MatchInfo();
                        info2.act = actM;
                        info2.score = actM.hisRequest.slotVal > 0.0 ? actM.hisCost.slotVal / actM.hisRequest.slotVal : 0.0;
                        slotCandis.add(info2);
                    }
                    if (aconfidence > 0.99 || actM.hisClick.slotVal > 5.0) {
                        info2 = new MatchInfo();
                        info2.act = actM;
                        info2.score = actM.hisRequest.appVal > 0.0 ? actM.hisCost.appVal / actM.hisRequest.appVal : 0.0;
                        appCandis.add(info2);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        HashSet<Long> idset = new HashSet<Long>();
        int size1 = slotCandis.size();
        for (int i2 = 0; i2 < 10 && i2 < size1; ++i2) {
            ActivityInfoModel act = ((MatchInfo)slotCandis.poll()).act;
            result.add(act);
            idset.add(act.activityId);
        }
        int size = candis.size();
        for (int i3 = 0; i3 < topn && i3 < size; ++i3) {
            ActivityInfoModel act = ((MatchInfo)candis.poll()).act;
            if (idset.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
        }
        if (result.size() < topn) {
            int count = topn;
            int i4 = 0;
            while ((long)i4 < size_act) {
                if (!idset.contains(actDataCopy.get((int)i4).activityId)) {
                    idset.add(actDataCopy.get((int)i4).activityId);
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisClick.globalVal = actDataCopy.get((int)i4).click.globalVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisClick.appVal = actDataCopy.get((int)i4).click.appVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisClick.slotVal = actDataCopy.get((int)i4).click.slotVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisCost.globalVal = actDataCopy.get((int)i4).cost.globalVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisCost.appVal = actDataCopy.get((int)i4).cost.appVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisCost.slotVal = actDataCopy.get((int)i4).cost.slotVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisRequest.globalVal = actDataCopy.get((int)i4).request.globalVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisRequest.appVal = actDataCopy.get((int)i4).request.appVal;
                    ((ActivityInfoModel)actModelCopy.get((int)i4)).hisRequest.slotVal = actDataCopy.get((int)i4).request.slotVal;
                    result.add((ActivityInfoModel)actModelCopy.get(i4));
                    if (++count >= topn) break;
                }
                ++i4;
            }
        }
        return result;
    }

    public static ActivityModel select(List<ActivityModel> actModel, List<ActivityData> actData, double gama) {
        if (actModel.size() == 0 || actData.size() == 0) {
            return null;
        }
        if (actModel.size() != actData.size()) {
            return actModel.get(0);
        }
        List<ActivityModel> actModelCopy = ActivitySelector.sortByIdAndSourceModelBack(actModel);
        List<ActivityData> actDataCopy = ActivitySelector.sortByIdAndSourceDataBack(actData);
        for (int i = 0; i < actModelCopy.size(); ++i) {
            long activityIdMode = actModelCopy.get((int)i).activityId;
            long activityIdData = actDataCopy.get((int)i).activityId;
            if (activityIdMode == activityIdData) continue;
            return actModel.get(0);
        }
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Double> changeScores = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<ActivityModel> candiList = new ArrayList<ActivityModel>();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double maxGchange = Constant.MIN_REWARD;
        double maxHchange = Constant.MIN_REWARD;
        double maxAchange = Constant.MIN_REWARD;
        ActivityModel result = new ActivityModel();
        try {
            int i;
            for (i = 0; i < actDataCopy.size(); ++i) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(actDataCopy.get((int)i).activityId) ? (RankInfo)mMap.get(actDataCopy.get((int)i).activityId) : new RankInfo();
                info.grpm = grpm = actDataCopy.get((int)i).hisRequest.globalVal > 0.0 ? actDataCopy.get((int)i).hisCost.globalVal / actDataCopy.get((int)i).hisRequest.globalVal : 0.0;
                info.gexp = actDataCopy.get((int)i).hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = actDataCopy.get((int)i).hisRequest.appVal > 0.0 ? actData.get((int)i).hisCost.appVal / actData.get((int)i).hisRequest.appVal : 0.0;
                info.aexp = actDataCopy.get((int)i).hisRequest.appVal;
                if (info.hexp > 50.0) {
                    maxA = Math.max(arpm, maxA);
                }
                info.hrpm = hrpm = actDataCopy.get((int)i).hisRequest.slotVal > 0.0 ? actData.get((int)i).hisCost.slotVal / actData.get((int)i).hisRequest.slotVal : 0.0;
                info.hexp = actDataCopy.get((int)i).hisRequest.slotVal;
                mMap.put(actDataCopy.get((int)i).activityId, info);
            }
            for (i = 0; i < actDataCopy.size(); ++i) {
                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(actDataCopy.get((int)i).hisRequest.slotVal / 60.0, 1.0);
                double aconfidence = Math.min(actDataCopy.get((int)i).hisRequest.appVal / 60.0, 1.0);
                reward = sconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)actDataCopy.get((int)i).activityId))).grpm * 0.5, maxG, 0.6);
                System.out.println(actDataCopy.get(i) + " reward=" + reward);
                reward *= reward;
                reward = Math.max(reward, Constant.MIN_REWARD);
                actModelCopy.get((int)i).reward = actModelCopy.get((int)i).reward * decay + reward;
                actModelCopy.get((int)i).count = actModelCopy.get((int)i).count * decay + 1.0;
                actModelCopy.get((int)i).alpha = 1.5 + actModelCopy.get((int)i).reward;
                actModelCopy.get((int)i).beta = 2.0 + (actModelCopy.get((int)i).count - actModelCopy.get((int)i).reward);
                rewards.add(actModelCopy.get((int)i).reward);
                counts.add(actModelCopy.get((int)i).count);
                alphas.add(actModelCopy.get((int)i).alpha);
                betas.add(actModelCopy.get((int)i).beta);
                activityTypes.add(actModelCopy.get((int)i).activityType);
                activityIds.add(actModelCopy.get((int)i).activityId);
                changeScores.add(actModelCopy.get((int)i).changeScore);
                candiList.add(actModelCopy.get(i));
            }
            int numMachines = candiList.size();
            result = (ActivityModel)candiList.get(ActivitySelector.selectMachineWithChangeScore(alphas, betas, activityTypes, activityIds, changeScores, numMachines, gama));
            if (System.currentTimeMillis() - result.updateTime > 60000L) {
                result.isUpdate = true;
                result.updateTime = System.currentTimeMillis();
            }
            mMap.clear();
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString((Object)result)});
            return result;
        }
    }

    public static void print(ActivityInfo act) {
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.request.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("click = " + act.click.slotVal + "\t" + act.click.appVal + "\t" + act.click.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastClick = " + act.lastClick.slotVal + "\t" + act.lastClick.appVal + "\t" + act.lastClick.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
        System.out.println("hisClick = " + act.hisClick.slotVal + "\t" + act.hisClick.appVal + "\t" + act.hisClick.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    public static double calChangeScore(List<Advert> ads) {
        double changeScore = 0.0;
        double sumClick = 0.0;
        double sumEffectPV = 0.0;
        for (Advert ad : ads) {
            sumClick += (double)ad.click;
            sumEffectPV += (double)ad.effectPV;
        }
        for (Advert ad : ads) {
            double changeMore = ad.click > 0L ? (double)ad.effectPV / (double)ad.click : 0.0;
            changeMore = ad.globalCvr > 0.0 ? changeMore / ad.globalCvr : 0.0;
            double ratio = sumClick > 0.0 ? (double)ad.click / sumClick : 0.0;
            changeScore += ratio * (changeMore -= 1.0);
        }
        return sumEffectPV > 3.0 ? changeScore : 0.0;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private static int selectMachineWithChangeScore(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, List<Double> changeScores, int numMachines, double gama) {
        int i;
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new ArrayList<SelectInfo>();
        for (int i2 = 0; i2 < numMachines; ++i2) {
            double theta = BetaDistribution.BetaDist(alphas.get(i2), betas.get(i2));
            SelectInfo sinfo = new SelectInfo();
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i2);
            sinfo.index = i2;
            sinfo.activityId = activityIds.get(i2);
            sinfo.changeScore = changeScores.get(i2);
            sinfos.add(sinfo);
        }
        Collections.sort(sinfos, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList condi = new ArrayList();
        for (i = 0; i < sinfos.size(); ++i) {
            if (!(((SelectInfo)sinfos.get((int)0)).reward - ((SelectInfo)sinfos.get((int)i)).reward <= gama)) continue;
            System.out.println("condi " + i + " activityId=" + ((SelectInfo)sinfos.get((int)i)).activityId + " theta=" + ((SelectInfo)sinfos.get((int)i)).reward + "  activityType=" + ((SelectInfo)sinfos.get((int)i)).activityType + " changeScore=" + changeScores.get(i));
            condi.add(sinfos.get(i));
        }
        Collections.sort(condi, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                return 1;
            }
        });
        selectMachine = ((SelectInfo)condi.get((int)0)).index;
        for (i = 0; i < condi.size(); ++i) {
            if (((SelectInfo)condi.get((int)i)).activityType == 21L) continue;
            selectMachine = ((SelectInfo)condi.get((int)i)).index;
            break;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfoModel act;

        MatchInfo() {
        }
    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;
        double changeScore;

        SelectInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double gchange;
        double hrpm;
        double hexp;
        double hchange;
        double arpm;
        double aexp;
        double achange;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

