package cn.com.duiba.nezha.compute.common.model.pacing;

import java.util.Objects;

public class AdvertOrientInfo {

    Long advertId;
    Long orientId;
    String blackLevel;

    public AdvertOrientInfo() {
    }

    public AdvertOrientInfo(Long advertId, Long orientId, String blackLevel) {
        this.advertId = advertId;
        this.orientId = orientId;
        this.blackLevel = blackLevel;
    }

    public AdvertOrientInfo(Long advertId, Long orientId) {
        this.advertId = advertId;
        this.orientId = orientId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientId() {
        return orientId;
    }

    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    public String getBlackLevel() {
        return blackLevel;
    }

    public void setBlackLevel(String blackLevel) {
        this.blackLevel = blackLevel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdvertOrientInfo that = (AdvertOrientInfo) o;
        return Objects.equals(advertId, that.advertId) &&
                Objects.equals(orientId, that.orientId);
    }

    @Override
    public String toString() {
        return "AdvertOrientInfo{" +
                "advertId=" + advertId +
                ", orientId=" + orientId +
                '}';
    }

    @Override
    public int hashCode() {
        return Objects.hash(advertId, orientId);
    }
}
