package cn.com.duiba.nezha.compute.common.model.pacing;

import java.util.*;

public class SlotRecommender {
    public static Map<Boolean, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Collection<AdvertOrientInfo> blacklist) {


        Set<AdvertOrientInfo> orientSet = new HashSet<>();
        for (OrientInfo orient : orientlist) {
            //boolean isManagered = orient.isManagered; //是否为托管配置
            Integer chargeType = orient.chargeType;  //计费方式
            Long target = orient.target;  //目标成本
            Long fee = orient.fee; //出价
            Double cvr = orient.cvr;
            Double confidence = orient.confidence;   //置信度
            Double bias = orient.bias; //预估偏差
            Double orientCostG1d=orient.orientCostG1d;             //配置消耗
            Double orientClkG1d=orient.orientClkG1d;               //配置点击
            Double orientCvrG1d=orient.orientCvrG1d;               //配置cvr
            Double orientConvert=orientClkG1d*orientCvrG1d;

            Double orientCostConvert=(orientConvert!=0)?orientCostG1d/orientConvert:target;       //配置当天实际成本
            Double orientCostConvertbias=orientCostConvert/target;        //配置当天实际成本与目标成本偏差

            Random r = new Random();
            Double x = r.nextDouble();

            //////////ocpc
            if (chargeType == 2 && cvr != null) {
                double biasRatio = 0.8/orientCostConvertbias;
                double orientRatio = 0.5/orientCostConvertbias;
                double biasThreshold = (4 - (1 - confidence) * 2) * biasRatio;

                //对标配置定向发券，全部定向
                if (confidence > 1 && bias <= 4) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }

                //广告维度历史数据
                if (confidence > 0 && confidence <= 1 && bias > 0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }
                //不置信，且偏差0~2，且非低cvr,20%定向
                if (confidence == 0 && bias >= 0 && bias <= biasThreshold && cvr >= 0.05 && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }
                //不置信，且偏差0~2，且低cvr,10%定向
                if (confidence == 0 && bias >= 0 && bias <= biasThreshold && cvr < 0.05 && x < 0.5 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }
                //不置信，且偏差高，且非低cvr,4%定向
                if (confidence == 0 && bias > biasThreshold && cvr > 0.05 && x < 0.2 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }
            }

            ////////cpc   无置信的先开一点点
            else if (chargeType == 1 && cvr != null && cvr != 0) {
                double targetRatio = 0.8/orientCostConvertbias;
                double orientRatio = 0.01/orientCostConvertbias;
                double biasThreshold = (4 - (1 - confidence) * 2) * targetRatio;
                Double p_convert_cost = (cvr!=0)?fee / cvr:0.0;
                //对标配置定向
                if (confidence > 1 && p_convert_cost < 4 * target) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }

                //对标配置cvr=0或null
//                if (confidence > 1 && p_convert_cost == 0 && x < 0.2) {
//                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
//                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
//                }

                //广告维度历史数据
                if (confidence > 0 && confidence <= 1 && p_convert_cost < biasThreshold * target) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }

                //无数据，不置信，已纠偏
                if (confidence == 0 && bias != 0 && p_convert_cost < 0.8  * target && x < 1 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }
                //无数据，不置信，未纠偏
                if (confidence == 0 && bias == 0 && p_convert_cost < 0.8 * target && x < 0.6 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                    //if (Math.random()<0.000001) { logger.info("advertId:{} orientId:{}", orient.advertId, orient.orientId); }
                }
            }
        }
        Set<AdvertOrientInfo> orientPackageList = new HashSet<>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientSet.removeAll(blacklist);
        orientPackageList.removeAll(orientSet);

        Map<Boolean, Collection<AdvertOrientInfo>> map = new HashMap<>();
        map.put(true, orientSet);
        map.put(false, orientPackageList);
        return map;
    }
}
