package cn.com.duiba.nezha.compute.common.model.pacing;

import java.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotRecommender {

    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<Boolean, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Collection<AdvertOrientInfo> blacklist,Long slotId) {


        Map<String, String> blackMap = new HashMap<>();
        for (AdvertOrientInfo black : blacklist) {
            blackMap.put(black.advertId+"_"+black.orientId,black.blackLevel);
        }


        Set<AdvertOrientInfo> orientSet = new HashSet<>();
        Set<AdvertOrientInfo> blackSet = new HashSet<>();
        for (OrientInfo orient : orientlist) {
            //boolean isManagered = orient.isManagered; //是否为托管配置
            Integer chargeType = orient.chargeType;  //计费方式
            Long target = orient.target!=0?orient.target:1;  //目标成本
            Long fee = orient.fee; //出价
            Double cvr = orient.cvr;
            Double confidence = orient.confidence;   //置信度
            Double bias = orient.bias; //预估偏差
            Double orientCostG1d = orient.orientCostG1d != null ? orient.orientCostG1d : 0.0;             //配置消耗
            Double orientCostG7d = orient.orientCostG7d != null ? orient.orientCostG7d : 0.0;             //配置消耗
            Double orientClkG1d = orient.orientClkG1d != null ? orient.orientClkG1d : 0.0;               //配置点击
            Double orientCvrG1d = orient.orientCvrG1d != null ? orient.orientCvrG1d : 0.0;               //配置cvr
            Double orientConvert = orientClkG1d * orientCvrG1d;
            Double orientConfidence = orientCostG1d/(target*5);
            Double orientCostConvert = (orientConvert != 0 && orientCostG1d != 0) ? orientCostG1d / orientConvert : target;       //配置当天实际成本
            Double orientCostConvertbias = (orientConvert != 0) ? orientCostConvert / target : orientCostG1d / target;        //配置当天实际成本与目标成本偏差

            Double slotOrientationCost=orient.slotOrientationCost!=null?orient.slotOrientationCost:0.0;          //广告位+配置粒度消耗
            Double slotOrientationConvert=orient.slotOrientationConvert!=null?orient.slotOrientationConvert:0.0;   //广告位+配置粒度转化量
            Double slotOrientationConfidence=slotOrientationCost/(target*5);  //广告位+配置粒度置信度
            Double slotOrientationCostConvert=(slotOrientationCost!=0 && slotOrientationConvert!=0)?slotOrientationCost/slotOrientationConvert:target;  //广告位+配置粒度实时成本
            Double slotOrientationCostConvertBias=(slotOrientationConvert!=0) ? slotOrientationCostConvert / target : slotOrientationCost / target;


            String advertOrientId = orient.advertId + "_" + orient.orientId;
            String blackLevel = blackMap.get(advertOrientId);

            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double startRatio = (orientCostG7d < 5 * target) ? 0.5 : 1; //启动时减缓消耗速度控制因子


            //熔断开关
            Boolean isFuse=orientCostG1d>50000 && orientCostConvertbias>2;


            //////////ocpc
            if (chargeType == 2 && cvr!=null && confidence!=null && bias!=null && !isFuse) {

                //黑名单
                if (orientCostConvertbias>1.6 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel)  || "b3".equals(blackLevel))){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias>1.5 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel))){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias>1.3 && ("b0".equals(blackLevel) || "b1".equals(blackLevel)) ){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias>1.1 && "b0".equals(blackLevel)){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }

                //选配置
                biasRatio = (orientCostConvertbias!=0)?0.5/(orientCostConvertbias * orientCostConvertbias):0.5;
                orientRatio = (orientCostConvertbias!=0)?0.5/(orientCostConvertbias * orientCostConvertbias):0.5;
                biasThreshold = Math.max((3 - (1 - confidence) * 2) * biasRatio * startRatio,1);


                //广告维度历史数据
                if (confidence > 0 && bias>0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }

                //不置信，且偏差0~2，且非低cvr,20%定向
                if (confidence == 0  && bias>0 && bias <= biasThreshold && cvr >= 0.05 && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }

                //不置信，且偏差0~2，且低cvr,10%定向
                if (confidence == 0  && bias>0 && bias <= biasThreshold && cvr < 0.05 && x < 0.5 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }

                //不置信，且偏差高，且非低cvr,4%定向
//                if (confidence == 0 && bias > biasThreshold && cvr > 0.05 && x < 0.2 * orientRatio) {
//                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
//
//                }
                //成本过高时降低低置信，低偏差定向概率
//                if (orientConfidence>1 && orientCostConvertbias>=1.5 && confidence <= 0.3 && x > 2*confidence/orientCostConvertbias) {
//                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
//                }

                //根据广告位+配置粒度实时成本进行删减
                if ( slotOrientationConfidence>=0.2 && slotOrientationCostConvertBias<=Math.max(1.2/orientCostConvertbias,1.0)){
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence>=1 && orientCostConvertbias>1.2 && slotOrientationConfidence>=0.5 && slotOrientationCostConvertBias>3.5/(orientCostConvertbias*orientCostConvertbias)){
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence>=1 && orientCostConvertbias>1.5 && slotOrientationConfidence<0.5  && x>2*slotOrientationConfidence/(orientCostConvertbias*slotOrientationCostConvertBias)){
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
            }

            ////////cpc
            else if (chargeType == 1  && cvr!=null && confidence!=null && bias!=null && !isFuse) {

                //黑名单
                if (orientCostConvertbias>1.5 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel)  || "b3".equals(blackLevel))){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias>1.4 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel))){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias>1.2 && ("b0".equals(blackLevel) || "b1".equals(blackLevel)) ){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias>1.1 && "b0".equals(blackLevel)){
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }

                //选配置
                targetRatio = (orientCostConvertbias!=0)?0.5/(orientCostConvertbias * orientCostConvertbias):0.5;
                orientRatio = (orientCostConvertbias!=0)?0.01/(orientCostConvertbias * orientCostConvertbias):0.01;
                biasThreshold = Math.max((2 - (1 - confidence) * 2) * targetRatio  * startRatio,1);
                p_convert_cost = (cvr!=0)?fee / cvr:1000000.0;

                //对标配置定向
//                if (confidence > 1 && p_convert_cost <= biasThreshold * target) {
//                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
//
//                }

                //广告维度历史数据
                if (confidence > 0 && p_convert_cost <= biasThreshold * target) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));

                }

                //无数据，不置信，已纠偏
                if (confidence == 0 && bias != 0 && p_convert_cost < 0.8  * target && x < 1 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));

                }

                //无数据，不置信，未纠偏
                if (confidence == 0 && bias == 0 && p_convert_cost < 0.8 * target && x < 0.6 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));

                }

                //成本过高时降低低置信，低偏差定向概率
//                if (orientConfidence>1 && orientCostConvertbias>=1.5 && confidence <= 0.3 && x > 2*confidence/orientCostConvertbias) {
//                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
//                }

                //根据广告位+配置粒度实时成本进行删减
                if (slotOrientationConfidence>=0.2 && slotOrientationCostConvertBias<=Math.max(1.2/orientCostConvertbias,1.0)){
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence>=1 && orientCostConvertbias>1.2 && slotOrientationConfidence>=0.5 && slotOrientationCostConvertBias>3.5/(orientCostConvertbias*orientCostConvertbias)){
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence>=1 && orientCostConvertbias>1.5 && slotOrientationConfidence<0.5  && x>2*slotOrientationConfidence/(orientCostConvertbias*slotOrientationCostConvertBias)){
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }

            }

            if (Math.random()<0.001 && confidence!=null) {
                logger.info("slot_rec advertId:{}" +
                                " orientId:{} " +
                                "slotId:{}"+
                                "chargeType:{}" +
                                " confidence:{} " +
                                "bias:{} " +
                                "cvr:{} " +
                                "cost:{} " +
                                "p_convert_cost:{} " +
                                "r_convert_cost:{} " +
                                "biasThreshold:{} " +
                                "orientRatio:{} " +
                                "biasRatio:{} " +
                                "targetRatio:{} " +
                                "target:{} "+
                                "slotOrientationCost:{} "+
                                "slotOrientationConvert:{} "
                        ,
                        orient.advertId, orient.orientId, slotId,chargeType, confidence, bias,cvr,orient.orientCostG1d,
                        p_convert_cost, orientCostConvert,biasThreshold,orientRatio,biasRatio,targetRatio,target,
                        slotOrientationCost,slotOrientationConvert
                );
            }
        }


        if (blackSet.size()!=0 && Math.random()<0.1) {
            logger.info("slot_blackset slotId:{},blackSet:{}", slotId,blackSet);
        }

        Set<AdvertOrientInfo> orientPackageList = new HashSet<>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientSet.removeAll(blackSet);
        orientPackageList.removeAll(orientSet);


        Map<Boolean, Collection<AdvertOrientInfo>> map = new HashMap<>();
        map.put(true, orientSet);
        map.put(false, orientPackageList);

        return map;
    }
}
