/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.OrientInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotRecommender {
    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<Boolean, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Collection<AdvertOrientInfo> blacklist, Long slotId) {
        HashMap<String, String> blackMap = new HashMap<String, String>();
        for (AdvertOrientInfo black : blacklist) {
            blackMap.put(black.advertId + "_" + black.orientId, black.blackLevel);
        }
        HashSet<AdvertOrientInfo> orientSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> blackSet = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orient : orientlist) {
            Integer chargeType = orient.chargeType;
            Long target = orient.target != 0L ? orient.target : 1L;
            Long fee = orient.fee;
            Double cvr = orient.cvr;
            Double confidence = orient.confidence;
            Double bias = orient.bias;
            Double orientCostG1d = orient.orientCostG1d != null ? orient.orientCostG1d : 0.0;
            Double orientCostG7d = orient.orientCostG7d != null ? orient.orientCostG7d : 0.0;
            Double orientClkG1d = orient.orientClkG1d != null ? orient.orientClkG1d : 0.0;
            Double orientCvrG1d = orient.orientCvrG1d != null ? orient.orientCvrG1d : 0.0;
            Double orientConvert = orientClkG1d * orientCvrG1d;
            Double orientConfidence = orientCostG1d / (double)(target * 5L);
            Double orientCostConvert = orientConvert != 0.0 && orientCostG1d != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
            Double orientCostConvertbias = orientConvert != 0.0 ? orientCostConvert / (double)target.longValue() : orientCostG1d / (double)target.longValue();
            Double slotOrientationCost = orient.slotOrientationCost != null ? orient.slotOrientationCost : 0.0;
            Double slotOrientationConvert = orient.slotOrientationConvert != null ? orient.slotOrientationConvert : 0.0;
            Double slotOrientationConfidence = slotOrientationCost / (double)(target * 5L);
            Double slotOrientationCostConvert = slotOrientationCost != 0.0 && slotOrientationConvert != 0.0 ? slotOrientationCost / slotOrientationConvert : (double)target.longValue();
            Double slotOrientationCostConvertBias = slotOrientationConvert != 0.0 ? slotOrientationCostConvert / (double)target.longValue() : slotOrientationCost / (double)target.longValue();
            String advertOrientId = orient.advertId + "_" + orient.orientId;
            String blackLevel = (String)blackMap.get(advertOrientId);
            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double startRatio = orientCostG7d < (double)(5L * target) ? 0.5 : 1.0;
            Boolean isFuse = orientCostG1d > 50000.0 && orientCostConvertbias > 2.0;
            if (chargeType == 2 && cvr != null && confidence != null && bias != null && !isFuse.booleanValue()) {
                if (orientCostConvertbias > 1.6 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel) || "b3".equals(blackLevel))) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias > 1.5 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel))) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias > 1.3 && ("b0".equals(blackLevel) || "b1".equals(blackLevel))) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias > 1.1 && "b0".equals(blackLevel)) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                biasRatio = orientCostConvertbias != 0.0 ? 0.5 / (orientCostConvertbias * orientCostConvertbias) : 0.5;
                orientRatio = orientCostConvertbias != 0.0 ? 0.5 / (orientCostConvertbias * orientCostConvertbias) : 0.5;
                biasThreshold = Math.max((3.0 - (1.0 - confidence) * 2.0) * biasRatio * startRatio, 1.0);
                if (confidence > 0.0 && bias > 0.0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (confidence == 0.0 && bias > 0.0 && bias <= biasThreshold && cvr >= 0.05 && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (confidence == 0.0 && bias > 0.0 && bias <= biasThreshold && cvr < 0.05 && x < 0.5 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (slotOrientationConfidence >= 0.2 && slotOrientationCostConvertBias <= Math.max(1.2 / orientCostConvertbias, 1.0)) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence >= 1.0 && orientCostConvertbias > 1.2 && slotOrientationConfidence >= 0.5 && slotOrientationCostConvertBias > 3.5 / (orientCostConvertbias * orientCostConvertbias)) {
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence >= 1.0 && orientCostConvertbias > 1.5 && slotOrientationConfidence < 0.5 && x > 2.0 * slotOrientationConfidence / (orientCostConvertbias * slotOrientationCostConvertBias)) {
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
            } else if (chargeType == 1 && cvr != null && confidence != null && bias != null && !isFuse.booleanValue()) {
                if (orientCostConvertbias > 1.5 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel) || "b3".equals(blackLevel))) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias > 1.4 && ("b0".equals(blackLevel) || "b1".equals(blackLevel) || "b2".equals(blackLevel))) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias > 1.2 && ("b0".equals(blackLevel) || "b1".equals(blackLevel))) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                } else if (orientCostConvertbias > 1.1 && "b0".equals(blackLevel)) {
                    blackSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                targetRatio = orientCostConvertbias != 0.0 ? 0.5 / (orientCostConvertbias * orientCostConvertbias) : 0.5;
                orientRatio = orientCostConvertbias != 0.0 ? 0.01 / (orientCostConvertbias * orientCostConvertbias) : 0.01;
                biasThreshold = Math.max((2.0 - (1.0 - confidence) * 2.0) * targetRatio * startRatio, 1.0);
                double d = p_convert_cost = cvr != 0.0 ? (double)fee.longValue() / cvr : 1000000.0;
                if (confidence > 0.0 && p_convert_cost <= biasThreshold * (double)target.longValue()) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (confidence == 0.0 && bias != 0.0 && p_convert_cost < 0.8 * (double)target.longValue() && x < 1.0 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (confidence == 0.0 && bias == 0.0 && p_convert_cost < 0.8 * (double)target.longValue() && x < 0.6 * orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (slotOrientationConfidence >= 0.2 && slotOrientationCostConvertBias <= Math.max(1.2 / orientCostConvertbias, 1.0)) {
                    orientSet.add(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence >= 1.0 && orientCostConvertbias > 1.2 && slotOrientationConfidence >= 0.5 && slotOrientationCostConvertBias > 3.5 / (orientCostConvertbias * orientCostConvertbias)) {
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
                if (orientConfidence >= 1.0 && orientCostConvertbias > 1.5 && slotOrientationConfidence < 0.5 && x > 2.0 * slotOrientationConfidence / (orientCostConvertbias * slotOrientationCostConvertBias)) {
                    orientSet.remove(new AdvertOrientInfo(orient.advertId, orient.orientId));
                }
            }
            if (!(Math.random() < 0.001) || confidence == null) continue;
            logger.info("slot_rec advertId:{} orientId:{} slotId:{}chargeType:{} confidence:{} bias:{} cvr:{} cost:{} p_convert_cost:{} r_convert_cost:{} biasThreshold:{} orientRatio:{} biasRatio:{} targetRatio:{} target:{} slotOrientationCost:{} slotOrientationConvert:{} ", new Object[]{orient.advertId, orient.orientId, slotId, chargeType, confidence, bias, cvr, orient.orientCostG1d, p_convert_cost, orientCostConvert, biasThreshold, orientRatio, biasRatio, targetRatio, target, slotOrientationCost, slotOrientationConvert});
        }
        if (blackSet.size() != 0 && Math.random() < 0.1) {
            logger.info("slot_blackset slotId:{},blackSet:{}", (Object)slotId, blackSet);
        }
        HashSet<AdvertOrientInfo> orientPackageList = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientSet.removeAll(blackSet);
        orientPackageList.removeAll(orientSet);
        HashMap<Boolean, Collection<AdvertOrientInfo>> map = new HashMap<Boolean, Collection<AdvertOrientInfo>>();
        map.put(true, orientSet);
        map.put(false, orientPackageList);
        return map;
    }
}

