/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.feedback;

import cn.com.duiba.nezha.compute.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.TrusteeshipParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedBack {
    private static final Logger logger = LoggerFactory.getLogger(FeedBack.class);

    public static String autoManageFeedBack(OrientInfo orient, TrusteeshipParams.FeedBackParams feedBackparams) {
        Long target = orient.getTarget() != 0L ? orient.getTarget() : 1L;
        Double orientCostG1d = orient.getOrientCostG1d() != null ? orient.getOrientCostG1d() : 0.0;
        Double orientConvert = orient.getOrientConvertG1d();
        Double orientConfidence = orientCostG1d / (double)(target * 5L);
        Double orientCostConvert = orientConvert != 0.0 && orientCostG1d != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
        Double orientCostConvertbias = orientConvert != 0.0 ? orientCostConvert / (double)target.longValue() : orientCostG1d / (double)target.longValue();
        Double slotOrientationCost = orient.getSlotOrientationCost() != null ? orient.getSlotOrientationCost() : 0.0;
        Double slotOrientationConvert = orient.getSlotOrientationConvert() != null ? orient.getSlotOrientationConvert() : 0.0;
        Double slotOrientationConfidence = slotOrientationCost / (double)(target * 5L);
        Double slotOrientationCostConvert = slotOrientationCost != 0.0 && slotOrientationConvert != 0.0 ? slotOrientationCost / slotOrientationConvert : (double)target.longValue();
        Double slotOrientationCostConvertBias = slotOrientationConvert != 0.0 ? slotOrientationCostConvert / (double)target.longValue() : slotOrientationCost / (double)target.longValue();
        String label = "";
        if (orientCostG1d > (double)(5L * target) && orientConvert == 0.0) {
            label = "fuse1";
        } else if (orientCostG1d > feedBackparams.getFuseOrientCostG1dFactor() && orientCostConvertbias > feedBackparams.getFuseOrientCostConvertBiasFactor()) {
            label = "fuse2";
        } else {
            if (slotOrientationConfidence >= feedBackparams.getwSlotOrientationConfidenceFactor() && slotOrientationCostConvertBias <= Math.max(feedBackparams.getwSlotOrientationCostConvertBiasFactor() / orientCostConvertbias, 1.0)) {
                label = "w";
            }
            if (orientConfidence >= feedBackparams.getbOrientConfidenceFactor1() && orientCostConvertbias > feedBackparams.getbOrientCostConvertBiasFactor1() && slotOrientationConfidence >= feedBackparams.getbSlotOrientationConfidenceFactor1() && slotOrientationCostConvertBias > feedBackparams.getbSlotOrientationCostConvertBiasFactor1() / (orientCostConvertbias * orientCostConvertbias)) {
                label = "b";
            }
            if (orientConfidence >= feedBackparams.getbOrientConfidenceFactor2() && orientCostConvertbias > feedBackparams.getbOrientCostConvertBiasFactor2() && slotOrientationConfidence < feedBackparams.getbSlotOrientationConfidenceFactor2() && Math.random() > feedBackparams.getbSlotOrientRadioFactor2() * slotOrientationConfidence / (orientCostConvertbias * slotOrientationCostConvertBias)) {
                label = "b";
            }
        }
        return label;
    }
}

