/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselectchange;

import cn.com.duiba.nezha.compute.common.model.activityselectchange.ActivityInfo;
import cn.com.duiba.nezha.compute.common.model.activityselectchange.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.activityselectchange.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.activityselectchange.WilsonPair;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static int totalCounts = 0;
    public static int Counts = 0;
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    public static int getCoef(double hisRequest, double request, double hisClick, double click) {
        int coef = 1;
        int i = 1;
        int j = 1;
        if (request < 0.0) {
            for (i = 1; i < 144 && !((request += hisRequest / 144.0) > 0.0); ++i) {
            }
        }
        if (click < 0.0) {
            for (j = 1; j < 144 && !((click += hisClick / 144.0) > 0.0); ++j) {
            }
        }
        return coef += Math.max(i, j);
    }

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> slotCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> appCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        PriorityQueue<MatchInfo> globalCandis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        for (ActivityInfo activity : activityInfos) {
            try {
                MatchInfo info2;
                if (activity.source != 1L || !activity.valid) continue;
                activity.hisClick.globalVal = activity.click.globalVal;
                activity.hisClick.appVal = activity.click.appVal;
                activity.hisClick.slotVal = activity.directClick.slotVal;
                activity.hisCost.globalVal = activity.cost.globalVal;
                activity.hisCost.appVal = activity.cost.appVal;
                activity.hisCost.slotVal = activity.directCost.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;
                int limit = topn--;
                if (activity.hisRequest.globalVal < 100.0) {
                    if (System.currentTimeMillis() - activity.createTime < 259200000L) {
                        if (!(Math.random() < 1.0E-4)) continue;
                        result.add(activity);
                        continue;
                    }
                    if (activityInfos.size() <= limit || !(Math.random() < 1.0E-5)) continue;
                    result.add(activity);
                    --topn;
                    continue;
                }
                double slotScore = WilsonInterval.wilsonCalc((long)((long)activity.hisClick.slotVal), (long)((long)activity.hisRequest.slotVal * 3L)).lowerBound;
                double globalScore = WilsonInterval.wilsonCalc((long)((long)activity.hisClick.globalVal), (long)((long)activity.hisRequest.globalVal * 3L)).lowerBound;
                double appScore = WilsonInterval.wilsonCalc((long)((long)activity.hisClick.appVal), (long)((long)activity.hisRequest.appVal * 3L)).lowerBound;
                double coef = 0.0;
                double matchscore = 0.0;
                double sconfidence = Math.min(activity.hisRequest.slotVal / 100.0, 1.0);
                double aconfidence = Math.min(activity.hisRequest.appVal / 100.0, 1.0);
                double gconfidence = Math.min(activity.hisRequest.globalVal / 1000.0, 1.0);
                matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);
                MatchInfo info = new MatchInfo();
                info.act = activity;
                info.score = matchscore;
                candis.add(info);
                if (sconfidence > 0.99 || activity.hisClick.slotVal > 5.0) {
                    info2 = new MatchInfo();
                    info2.act = activity;
                    info2.score = activity.hisRequest.slotVal > 0.0 ? activity.hisCost.slotVal / activity.hisRequest.slotVal : 0.0;
                    slotCandis.add(info2);
                }
                if (!(aconfidence > 0.99) && !(activity.hisClick.slotVal > 5.0)) continue;
                info2 = new MatchInfo();
                info2.act = activity;
                info2.score = activity.hisRequest.appVal > 0.0 ? activity.hisCost.appVal / activity.hisRequest.appVal : 0.0;
                appCandis.add(info2);
            }
            catch (Exception e) {
                logger.error("error, act:{}", (Object)JSON.toJSONString((Object)activity));
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        HashSet<Long> idset = new HashSet<Long>();
        int size1 = slotCandis.size();
        for (int i = 0; i < 10 && i < size1; ++i) {
            ActivityInfo act = ((MatchInfo)slotCandis.poll()).act;
            result.add(act);
            idset.add(act.activityId);
        }
        int size = candis.size();
        for (int i = 0; i < topn && i < size; ++i) {
            ActivityInfo act = ((MatchInfo)candis.poll()).act;
            if (slotCandis.contains(act.activityId)) continue;
            result.add(act);
            idset.add(act.activityId);
        }
        if (result.size() < topn) {
            int count = topn;
            for (ActivityInfo activity : activityInfos) {
                if (activity.source != 1L || !activity.valid || idset.contains(activity.activityId)) continue;
                idset.add(activity.activityId);
                activity.hisClick.globalVal = activity.click.globalVal;
                activity.hisClick.appVal = activity.click.appVal;
                activity.hisClick.slotVal = activity.directClick.slotVal;
                activity.hisCost.globalVal = activity.cost.globalVal;
                activity.hisCost.appVal = activity.cost.appVal;
                activity.hisCost.slotVal = activity.directCost.slotVal;
                activity.hisRequest.globalVal = activity.request.globalVal;
                activity.hisRequest.appVal = activity.request.appVal;
                activity.hisRequest.slotVal = activity.directRequest.slotVal;
                result.add(activity);
                if (++count < topn) continue;
                break;
            }
        }
        return result;
    }

    public static ActivityInfo select(List<ActivityInfo> activityInfos, double gama) {
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<Long> activityTypes = new ArrayList<Long>();
        ArrayList<ActivityInfo> candiList = new ArrayList<ActivityInfo>();
        double decay = Constant.DECAY;
        int size = 0;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = Constant.MIN_REWARD;
        double maxH = Constant.MIN_REWARD;
        double maxA = Constant.MIN_REWARD;
        double maxGchange = Constant.MIN_REWARD;
        double maxHchange = Constant.MIN_REWARD;
        double maxAchange = Constant.MIN_REWARD;
        ActivityInfo result = new ActivityInfo();
        try {
            List<ActivityInfo> matchActivityInfos = ActivitySelector.match(activityInfos, Constant.SEARANK_TOPN);
            size = matchActivityInfos.size();
            for (ActivityInfo act : matchActivityInfos) {
                double hrpm;
                double arpm;
                double grpm;
                RankInfo info = mMap.containsKey(act.activityId) ? (RankInfo)mMap.get(act.activityId) : new RankInfo();
                info.grpm = grpm = act.hisRequest.globalVal > 0.0 ? act.hisCost.globalVal / act.hisRequest.globalVal : 0.0;
                info.gexp = act.hisRequest.globalVal;
                maxG = Math.max(grpm, maxG);
                info.arpm = arpm = act.hisRequest.appVal > 0.0 ? act.hisCost.appVal / act.hisRequest.appVal : 0.0;
                info.aexp = act.hisRequest.appVal;
                if (info.hexp > 50.0) {
                    maxA = Math.max(arpm, maxA);
                }
                info.hrpm = hrpm = act.hisRequest.slotVal > 0.0 ? act.hisCost.slotVal / act.hisRequest.slotVal : 0.0;
                info.hexp = act.hisRequest.slotVal;
                mMap.put(act.activityId, info);
            }
            for (ActivityInfo act : matchActivityInfos) {
                if (act.request.globalVal > 0.0) {
                    double reward = Constant.MIN_REWARD;
                    double sconfidence = Math.min(act.hisRequest.slotVal / 60.0, 1.0);
                    double aconfidence = Math.min(act.hisRequest.appVal / 60.0, 1.0);
                    reward = sconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).hrpm * 0.8, maxH, 0.8) + (1.0 - sconfidence) * aconfidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).arpm * 0.7, maxA, 0.7) + (1.0 - sconfidence - (1.0 - sconfidence) * aconfidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm * 0.5, maxG, 0.6);
                    reward *= reward;
                    reward = Math.max(reward, Constant.MIN_REWARD);
                    act.reward = act.reward * decay + reward;
                    act.count = act.count * decay + 1.0;
                    act.alpha = 1.5 + act.reward;
                    act.beta = 2.0 + (act.count - act.reward);
                }
                rewards.add(act.reward);
                counts.add(act.count);
                alphas.add(act.alpha);
                betas.add(act.beta);
                activityTypes.add(act.activityType);
                activityIds.add(act.activityId);
                candiList.add(act);
            }
            int numMachines = candiList.size();
            result = (ActivityInfo)candiList.get(ActivitySelector.selectMachineWithLowPackage(alphas, betas, activityTypes, activityIds, numMachines, gama));
            if (System.currentTimeMillis() - result.updateTime > 60000L) {
                result.isUpdate = true;
            }
            mMap.clear();
            result.lastRequest.appVal = result.request.appVal;
            result.lastRequest.slotVal = result.request.slotVal;
            result.lastRequest.globalVal = result.request.globalVal;
            result.lastClick.appVal = result.click.appVal;
            result.lastClick.slotVal = result.click.slotVal;
            result.lastClick.globalVal = result.click.globalVal;
            result.lastCost.appVal = result.cost.appVal;
            result.lastCost.slotVal = result.cost.slotVal;
            result.lastCost.globalVal = result.cost.globalVal;
            for (int i = 0; i < activityInfos.size(); ++i) {
                if (activityInfos.get((int)i).activityId != result.activityId) continue;
                activityInfos.get((int)i).isSelected = true;
            }
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("error, size:{},candi:{},list:{},", new Object[]{size, JSON.toJSONString(candiList), JSON.toJSONString(activityInfos)});
            for (int i = 0; i < activityInfos.size(); ++i) {
                if (activityInfos.get((int)i).activityId != result.activityId) continue;
                activityInfos.get((int)i).isSelected = true;
            }
            return result;
        }
    }

    public static void print(ActivityInfo act) {
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.request.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("click = " + act.click.slotVal + "\t" + act.click.appVal + "\t" + act.click.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastClick = " + act.lastClick.slotVal + "\t" + act.lastClick.appVal + "\t" + act.lastClick.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
        System.out.println("hisClick = " + act.hisClick.slotVal + "\t" + act.hisClick.appVal + "\t" + act.hisClick.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private static int selectMachineWithLowPackage(List<Double> alphas, List<Double> betas, List<Long> activityTypes, List<Long> activityIds, int numMachines, double gama) {
        int i;
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new ArrayList<SelectInfo>();
        for (int i2 = 0; i2 < numMachines; ++i2) {
            double theta = BetaDistribution.BetaDist(alphas.get(i2), betas.get(i2));
            SelectInfo sinfo = new SelectInfo();
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i2);
            sinfo.index = i2;
            sinfo.activityId = activityIds.get(i2);
            sinfos.add(sinfo);
        }
        Collections.sort(sinfos, new Comparator<SelectInfo>(){

            @Override
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if (sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                return 1;
            }
        });
        ArrayList condi = new ArrayList();
        for (i = 0; i < sinfos.size(); ++i) {
            if (!(((SelectInfo)sinfos.get((int)0)).reward - ((SelectInfo)sinfos.get((int)i)).reward <= gama)) continue;
            condi.add(sinfos.get(i));
        }
        System.out.println("condi.size=" + condi.size());
        totalCounts += condi.size();
        ++Counts;
        selectMachine = ((SelectInfo)sinfos.get((int)0)).index;
        for (i = 0; i < condi.size(); ++i) {
            if (((SelectInfo)condi.get((int)i)).activityType == 21L) continue;
            selectMachine = ((SelectInfo)sinfos.get((int)i)).index;
            break;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;

        MatchInfo() {
        }
    }

    static class SelectInfo {
        double reward;
        long activityType;
        int index;
        long activityId;

        SelectInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double gchange;
        double hrpm;
        double hexp;
        double hchange;
        double arpm;
        double aexp;
        double achange;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;
        static int SEARANK_TOPN = 30;

        Constant() {
        }
    }
}

