/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.pacing;

import cn.com.duiba.nezha.compute.common.model.feedback.FeedBack;
import cn.com.duiba.nezha.compute.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.compute.common.model.pacing.ResultType;
import cn.com.duiba.nezha.compute.common.model.pacing.TrusteeshipParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotRecommender {
    private static final Logger logger = LoggerFactory.getLogger(SlotRecommender.class);

    public static Map<ResultType, Collection<AdvertOrientInfo>> recommend(Collection<OrientInfo> orientlist, Long slotId, TrusteeshipParams trusteeshipParams) {
        HashSet<AdvertOrientInfo> orientSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> fuseSet1 = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> fuseSet2 = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> recommendListSet = new HashSet<AdvertOrientInfo>();
        HashSet<AdvertOrientInfo> shieldListSet = new HashSet<AdvertOrientInfo>();
        TrusteeshipParams.SlotRecommendParams slotRecommendParams = trusteeshipParams.getSlotRecommendParams();
        TrusteeshipParams.FeedBackParams feedBackParams = trusteeshipParams.getFeedBackParams();
        if (Math.random() < 1.0E-4) {
            logger.info("params slotRecommendParams:{},feedBackParams:{}", (Object)slotRecommendParams, (Object)feedBackParams);
        }
        for (OrientInfo orientInfo : orientlist) {
            List<Object> biasList;
            Integer manageType = orientInfo.manageType;
            Integer chargeType = orientInfo.chargeType;
            Long target = orientInfo.target != 0L ? orientInfo.target : 1L;
            Long fee = orientInfo.fee;
            Double appOrientCvrDay = orientInfo.appOrientCvrDay != null ? orientInfo.appOrientCvrDay : 0.0;
            Double startFactor = manageType == 2 ? slotRecommendParams.getStartFactor1() : slotRecommendParams.getStartFactorCostconvertPrior2();
            Double cpaBiasRatioFactor = manageType == 2 ? slotRecommendParams.getCpaBiasRatioFactor1() : slotRecommendParams.getCpaBiasRatioFactorCostconvertPrior2();
            Double cpaOrientRatioFactor = manageType == 2 ? slotRecommendParams.getCpaOrientRatioFactor1() : slotRecommendParams.getCpaOrientRatioFactorCostconvertPrior2();
            Double cpaBiasThresholdFactor = manageType == 2 ? slotRecommendParams.getCpaBiasThresholdFactor1() : slotRecommendParams.getCpaBiasThresholdFactorCostconvertPrior2();
            Double cpcTargetRatioFactor = manageType == 2 ? slotRecommendParams.getCpcTargetRatioFactor1() : slotRecommendParams.getCpcTargetRatioFactorCostconvertPrior2();
            Double cpcOrientRatioFactor = manageType == 2 ? slotRecommendParams.getCpcOrientRatioFactor1() : slotRecommendParams.getCpcOrientRatioFactorCostconvertPrior2();
            Double cpcBiasThresholdFactor = manageType == 2 ? slotRecommendParams.getCpcBiasThresholdFactor1() : slotRecommendParams.getCpcBiasThresholdFactorCostconvertPrior2();
            List<Object> priceSectionList = orientInfo.priceSection == null ? new ArrayList() : orientInfo.priceSection;
            List<Object> cvrList = orientInfo.cvrSet == null ? new ArrayList() : orientInfo.cvrSet;
            List<Object> confidenceList = orientInfo.confidenceSet == null ? new ArrayList() : orientInfo.confidenceSet;
            List<Object> list = biasList = orientInfo.biasSet == null ? new ArrayList() : orientInfo.biasSet;
            if (Math.random() < 0.001 && !confidenceList.isEmpty()) {
                logger.info("OrientInfo OrientInfo:{} slotId:{}", (Object)orientInfo, (Object)slotId);
            }
            HashMap<String, Object> candidateMap = new HashMap<String, Object>();
            if (chargeType == 2 && priceSectionList.size() == 2 && confidenceList.size() == 3 && biasList.size() == 3) {
                candidateMap.put("confidence", confidenceList.get(2));
                candidateMap.put("bias", biasList.get(2));
            } else if (chargeType == 1 && priceSectionList.size() == 2 && confidenceList.size() == 3 && cvrList.size() == 3) {
                if ((double)fee.longValue() > (Double)priceSectionList.get(1)) {
                    candidateMap.put("confidence", confidenceList.get(2));
                    candidateMap.put("cvr", cvrList.get(2));
                } else if ((double)fee.longValue() > (Double)priceSectionList.get(0)) {
                    candidateMap.put("confidence", confidenceList.get(1));
                    candidateMap.put("cvr", cvrList.get(1));
                } else {
                    candidateMap.put("confidence", confidenceList.get(0));
                    candidateMap.put("cvr", cvrList.get(0));
                }
            }
            Double orientCostG1d = orientInfo.orientCostG1d != null ? orientInfo.orientCostG1d : 0.0;
            Double orientCostG7d = orientInfo.orientCostG7d != null ? orientInfo.orientCostG7d : 0.0;
            Double orientConvert = orientInfo.orientConvertG1d;
            Double orientCostConvert = orientConvert != 0.0 && orientCostG1d != 0.0 ? orientCostG1d / orientConvert : (double)target.longValue();
            Double orientCostConvertbias = orientConvert != 0.0 ? orientCostConvert / (double)target.longValue() : orientCostG1d / (double)target.longValue();
            Double orientConfidence = orientCostG1d / (double)(target * 5L);
            Double slotOrientationCost = orientInfo.slotOrientationCost != null ? orientInfo.slotOrientationCost : 0.0;
            Double slotOrientationConvert = orientInfo.slotOrientationConvert != null ? orientInfo.slotOrientationConvert : 0.0;
            Double slotOrientationConfidence = slotOrientationCost / (double)(target * 5L);
            Double slotOrientationCostConvert = slotOrientationCost != 0.0 && slotOrientationConvert != 0.0 ? slotOrientationCost / slotOrientationConvert : (double)target.longValue();
            Double slotOrientationCostConvertBias = slotOrientationConvert != 0.0 ? slotOrientationCostConvert / (double)target.longValue() : slotOrientationCost / (double)target.longValue();
            Double appOrientationCost = orientInfo.appOrientationCost != null ? orientInfo.appOrientationCost : 0.0;
            Double appOrientationConvert = orientInfo.appOrientationConvert != null ? orientInfo.appOrientationConvert : 0.0;
            Double appOrientationConfidence = appOrientationCost / (double)(target * 5L);
            Double appOrientationCostConvert = appOrientationCost != 0.0 && appOrientationConvert != 0.0 ? appOrientationCost / appOrientationConvert : (double)target.longValue();
            Double appOrientationCostConvertBias = appOrientationConvert != 0.0 ? appOrientationCostConvert / (double)target.longValue() : appOrientationCost / (double)target.longValue();
            Random r = new Random();
            Double x = r.nextDouble();
            double p_convert_cost = 0.0;
            double biasRatio = 0.0;
            double biasThreshold = 0.0;
            double orientRatio = 0.0;
            double targetRatio = 0.0;
            double startRatio = orientCostG7d < (double)(5L * target) ? startFactor : 1.0;
            String feedBackLabel = FeedBack.autoManageFeedBack(orientInfo, feedBackParams);
            if (!"".equals(feedBackLabel) && Math.random() < 0.02) {
                logger.info("slot_blackset slotId:{},advertId:{},orientId:{},feedBackLabel:{}", new Object[]{slotId, orientInfo.advertId, orientInfo.orientId, feedBackLabel});
            }
            Boolean isFuse = "fuse1".equals(feedBackLabel) || "fuse2".equals(feedBackLabel);
            if ("fuse1".equals(feedBackLabel)) {
                fuseSet1.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            } else if ("fuse2".equals(feedBackLabel)) {
                fuseSet2.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            }
            if (isFuse.booleanValue()) {
                logger.info("fuseInfo fuseOrientInfo:{}", (Object)orientInfo);
            }
            Double confidence = (Double)candidateMap.get("confidence");
            Double cvr = (Double)candidateMap.get("cvr");
            Double bias = (Double)candidateMap.get("bias");
            if (chargeType == 2 && confidence != null && bias != null && !isFuse.booleanValue()) {
                biasRatio = orientCostConvertbias != 0.0 ? cpaBiasRatioFactor / (orientCostConvertbias * orientCostConvertbias) : cpaBiasRatioFactor;
                orientRatio = orientCostConvertbias != 0.0 ? cpaOrientRatioFactor / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : cpaOrientRatioFactor;
                orientRatio = orientCostConvertbias > 1.7 ? 0.0 : orientRatio;
                biasThreshold = Math.max((cpaBiasThresholdFactor * confidence + 1.0) * biasRatio * startRatio, 1.0);
                if (confidence > 0.0 && bias > 0.0 && bias <= biasThreshold) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
                if (confidence == 0.0 && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
            } else if (chargeType == 1 && confidence != null && cvr != null && !isFuse.booleanValue()) {
                targetRatio = orientCostConvertbias != 0.0 ? cpcTargetRatioFactor / (orientCostConvertbias * orientCostConvertbias) : cpcTargetRatioFactor;
                orientRatio = orientCostConvertbias != 0.0 ? cpcOrientRatioFactor / (orientCostConvertbias * orientCostConvertbias * orientCostConvertbias) : cpcOrientRatioFactor;
                orientRatio = orientCostConvertbias > 1.5 ? 0.0 : orientRatio;
                biasThreshold = Math.max((cpcBiasThresholdFactor * confidence + 1.0) * targetRatio * startRatio, 1.0);
                double d = p_convert_cost = cvr != 0.0 ? (double)fee.longValue() / cvr : 1000000.0;
                if (confidence > 0.0 && p_convert_cost <= biasThreshold * (double)target.longValue()) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
                if (confidence == 0.0 && p_convert_cost < biasThreshold * (double)target.longValue() && x < orientRatio) {
                    orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                    if (manageType == 3) {
                        recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, slotOrientationCostConvertBias, slotOrientationCost));
                    }
                }
            }
            if ("w".equals(feedBackLabel)) {
                orientSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
                if (manageType == 3) {
                    recommendListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, appOrientationCostConvertBias, appOrientationCost));
                }
            }
            if (!"b".equals(feedBackLabel)) continue;
            orientSet.remove(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
            if (manageType != 2 || !(appOrientationConfidence > 1.0) || !(appOrientationCostConvertBias > 2.0)) continue;
            shieldListSet.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId, appOrientationCostConvertBias, appOrientationCost));
        }
        HashSet<AdvertOrientInfo> orientPackageList = new HashSet<AdvertOrientInfo>();
        for (OrientInfo orientInfo : orientlist) {
            orientPackageList.add(new AdvertOrientInfo(orientInfo.advertId, orientInfo.orientId));
        }
        orientPackageList.removeAll(orientSet);
        orientPackageList.removeAll(shieldListSet);
        HashMap<ResultType, Collection<AdvertOrientInfo>> hashMap = new HashMap<ResultType, Collection<AdvertOrientInfo>>();
        hashMap.put(ResultType.ONTARGET, orientSet);
        hashMap.put(ResultType.GIVEUP, orientPackageList);
        hashMap.put(ResultType.FUSE1, fuseSet1);
        hashMap.put(ResultType.FUSE2, fuseSet2);
        hashMap.put(ResultType.ORIENT, recommendListSet);
        hashMap.put(ResultType.SHIELD, shieldListSet);
        if (Math.random() < 0.002) {
            logger.info("ResultType ResultType:{},slotId:{}", hashMap, (Object)slotId);
        }
        return hashMap;
    }
}

