package cn.com.duiba.nezha.compute.common.model.activityselect;

import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;

public class ActivitySelectorTest extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.out.println();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.out.println();
    }

    public void testBayesianBandit() throws Exception { //几个候选集

        ActivitySelector bandit = new ActivitySelector();


        //初始化两个素材
        ActivityInfo a1 = new ActivityInfo();
        a1.activityId = 1;

        ActivityInfo.Val val = a1.getVal();
        val.globalVal = 2000;
        val.appVal = 1000;
        val.slotVal = 1000;
        a1.hisRequest = val;

        val = a1.getVal();
        val.globalVal = 600;
        val.appVal = 400;
        val.slotVal = 400;
        a1.hisSend = val;

        val.globalVal = 100;
        val.appVal = 60;
        val.slotVal = 60;
        a1.send = val;

        val.globalVal = 300;
        val.appVal = 100;
        val.slotVal = 100;
        a1.request = val;

        val.globalVal = 300;
        val.appVal = 100;
        val.slotVal = 100;
        a1.lastSend = val;

        val.globalVal = 300;
        val.appVal = 100;
        val.slotVal = 100;
        a1.lastRequest = val;

        a1.updateTime = 0;
        a1.isUpdate = true;

        ActivityInfo a2 = new ActivityInfo();
        a2.activityId = 1;

        ActivityInfo.Val val2 = a2.getVal();
        val2.globalVal = 2000;
        val2.appVal = 1000;
        val2.slotVal = 1000;
        a2.hisRequest = val2;

        val2 = a2.getVal();
        val2.globalVal = 600;
        val2.appVal = 400;
        val2.slotVal = 400;
        a2.hisSend = val2;

        val2.globalVal = 100;
        val2.appVal = 60;
        val2.slotVal = 60;
        a2.send = val2;

        val2.globalVal = 300;
        val2.appVal = 100;
        val2.slotVal = 100;
        a2.request = val2;

        val2.globalVal = 300;
        val2.appVal = 100;
        val2.slotVal = 100;
        a2.lastSend = val2;

        val2.globalVal = 400;
        val2.appVal = 200;
        val2.slotVal = 200;
        a2.lastRequest = val2;

        a2.updateTime = 0;
        a2.isUpdate = true;

        ArrayList<ActivityInfo> alist = new ArrayList<>();
        alist.add(a1);
        alist.add(a2);


        int cnt1 = 0,cnt2 = 0;
        System.out.println("materialId\talpha\tm.beta\tm.reward\tm.hctr");
        for(int i = 0;i<1000;i++)
        {
            ActivityInfo act = bandit.select(alist);

            for(ActivityInfo m:alist) {
                //System.out.println(m.materialId+"\t"+m.appId+"\t"+m.lastClick+"\t"+m.lastExposure);
                if (m.activityId == 2) {
                    alist.set(1, m);
                    cnt2++;
                } else if (m.activityId == 1) {
                    alist.set(0, m);
                    cnt1++;
                }
            }

           // System.out.println(m.materialId+"\t"+m.alpha+"\t"+m.beta+"\t"+m.reward/m.count+"\t"+m.lastClick+"\t"+m.lastExposure);
        }
        System.out.println("cnt1 = "+cnt1+" cnt2="+cnt2);

    }
}