/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model;

import cn.com.duiba.nezha.compute.common.model.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.MaterialInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayesianBandit {
    private static final Logger logger = LoggerFactory.getLogger(BayesianBandit.class);
    private ArrayList<Double> rewards = new ArrayList();
    private ArrayList<Double> counts = new ArrayList();
    private ArrayList<Double> alphas = new ArrayList();
    private ArrayList<Double> betas = new ArrayList();
    private int numMachines;
    private double decay = 1.0;

    public List<MaterialInfo> selectMaterial(List<MaterialInfo> materialList, Long appid) {
        this.clear();
        this.decay = Constant.DECAY;
        HashMap<Long, Info> mMap = new HashMap<Long, Info>();
        double maxG = 0.01;
        double maxH = 0.01;
        for (MaterialInfo m : materialList) {
            double hCtr;
            Info info;
            double click = this.sum(m.click);
            double exposure = this.sum(m.exposure);
            if (m.lastClick > (double)Constant.MAX_CLICK) {
                m.lastClick /= (double)Constant.DISCOUNT;
                m.lastExposure /= (double)Constant.DISCOUNT;
            }
            m.lastClick += this.getCtr(exposure, click);
            m.lastExposure += 1.0;
            if (m.appId == -1L) {
                double gCtr;
                info = mMap.containsKey(m.materialId) ? (Info)mMap.get(m.materialId) : new Info();
                info.gctr = gCtr = this.getCtr(m.lastExposure, m.lastClick);
                info.gexp = m.lastExposure;
                info.id = m.materialId;
                info.gMaterial = m;
                mMap.put(m.materialId, info);
                maxG = Math.max(gCtr, maxG);
                continue;
            }
            info = mMap.containsKey(m.materialId) ? (Info)mMap.get(m.materialId) : new Info();
            double rCtr = this.getCtr(exposure, click);
            info.hctr = hCtr = this.getCtr(m.lastExposure, m.lastClick);
            info.hexp = m.lastExposure;
            info.rctr = rCtr;
            info.rexp = exposure;
            info.id = m.materialId;
            mMap.put(m.materialId, info);
            if (!(info.hexp > 50.0)) continue;
            maxH = Math.max(hCtr, maxH);
        }
        ArrayList<MaterialInfo> candiList = new ArrayList<MaterialInfo>();
        for (MaterialInfo m : materialList) {
            if (m.appId == -1L) continue;
            double exposure = this.sum(m.exposure);
            if (exposure > 0.0) {
                double reward = Constant.MIN_REWARD;
                double confidence = m.lastClick > 50.0 ? 1.0 : m.lastClick / 50.0;
                reward = (1.0 - confidence) * this.normlize(((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr, maxG, 0.5) + confidence * this.normlize(((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).hctr, maxH, 0.5);
                reward = Math.max(reward, Constant.MIN_REWARD);
                if (m.materialId == 7375L && Math.random() < 0.01) {
                    logger.info("bandit mlist:{} materialId:{} appid:{} clk:{} hctr:{} maxh:{} reward:{} gctr:{} maxg:{}", new Object[]{materialList.size(), m.materialId, m.appId, m.lastClick, ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).hctr, maxH, reward, ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr, maxG});
                } else if (Math.random() < 1.0E-4) {
                    logger.info("bandit mlist:{} materialId:{} appid:{} clk:{} hctr:{} maxh:{} reward:{} gctr:{} maxg:{}", new Object[]{materialList.size(), m.materialId, m.appId, m.lastClick, ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).hctr, maxH, reward, ((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr, maxG});
                }
                if (m.count < 20.0) {
                    m.count = 20.0;
                    m.reward = Math.min(((Info)mMap.get((Object)Long.valueOf((long)m.materialId))).gctr * 0.5 * m.count / maxG, 0.5 * m.count);
                }
                m.reward = m.reward * this.decay + reward;
                m.count = m.count * this.decay + 1.0;
                m.alpha = 1.0 + m.reward;
                m.beta = 1.0 + (m.count - m.reward);
            }
            this.rewards.add(m.reward);
            this.counts.add(m.count);
            this.alphas.add(m.alpha);
            this.betas.add(m.beta);
            candiList.add(m);
        }
        this.numMachines = candiList.size();
        MaterialInfo material = (MaterialInfo)candiList.get(this.selectMachine());
        MaterialInfo gMaterial = ((Info)mMap.get((Object)Long.valueOf((long)material.materialId))).gMaterial;
        ArrayList<MaterialInfo> result = new ArrayList<MaterialInfo>();
        result.add(material);
        result.add(gMaterial);
        mMap.clear();
        return result;
    }

    public double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private void clear() {
        this.rewards = new ArrayList();
        this.counts = new ArrayList();
        this.alphas = new ArrayList();
        this.betas = new ArrayList();
    }

    private int selectMachine() {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < this.numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(this.alphas.get(i), this.betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    class Info {
        long id;
        double gctr;
        double gexp;
        double hctr;
        double hexp;
        double rctr;
        double rexp;
        MaterialInfo gMaterial;

        Info() {
        }
    }

    static class Constant {
        static double RT_REWARD_WEIGHT = 0.0;
        static double MIN_REWARD = 0.01;
        static long MAX_CLICK = 300L;
        static long DISCOUNT = 2L;
        static double DECAY = 0.999;

        Constant() {
        }
    }
}

