package cn.com.duiba.nezha.compute.common.model.activityselect;

import junit.framework.TestCase;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Comparator;

public class ActivitySelectorTest extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        System.out.println();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.out.println();
    }

    public void testBayesianBandit() throws Exception { //几个候选集

        ActivitySelector bandit = new ActivitySelector();


        //初始化两个素材
        ActivityInfo a1 = new ActivityInfo();
        a1.activityId = 4545;
        a1.alpha = 2;
        a1.beta = 2;
        a1.count = 0;
        a1.reward = 0;

        ActivityInfo.Val val = a1.getVal();
        val.globalVal = 0;
        val.appVal = 0;
        val.slotVal = 0;
        a1.hisRequest = val;

        val = a1.getVal();
        val.globalVal = 0;
        val.appVal = 0;
        val.slotVal = 0;
        a1.hisSend = val;

        val = a1.getVal();
        val.globalVal = 18;
        val.appVal = 2;
        val.slotVal = 0;
        a1.send = val;

        val = a1.getVal();
        val.globalVal = 46;
        val.appVal = 7;
        val.slotVal = 2;
        a1.request = val;

        val = a1.getVal();
        val.globalVal = 0;
        val.appVal = 0;
        val.slotVal = 0;
        a1.lastSend = val;

        val = a1.getVal();
        val.globalVal = 0;
        val.appVal = 0;
        val.slotVal = 0;
        a1.lastRequest = val;

        a1.updateTime = 1511319423773l;
        a1.isUpdate = true;


        ArrayList<ActivityInfo> alist = new ArrayList<>();
        alist.add(a1);


        int cnt1 = 0,cnt2 = 0;
        for(int i = 0;i<1;i++)
        {
            ActivityInfo act = bandit.select(alist);

            if (act.activityId == 2) {
                alist.set(1, act);//update
                cnt2++;
            } else if (act.activityId == 4545) {
                alist.set(0, act);
                cnt1++;
            }

            //System.out.println(m.materialId+"\t"+m.alpha+"\t"+m.beta+"\t"+m.reward/m.count+"\t"+m.lastClick+"\t"+m.lastExposure);
        }
        System.out.println("cnt1 = "+cnt1+" cnt2="+cnt2);
    }

    public Comparator<Integer> iComparator = new Comparator<Integer>() {

        @Override
        public int compare(Integer c1, Integer c2) {
            return (int) (c2 - c1);
        }
    };
}