/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.model.activityselect;

import cn.com.duiba.nezha.compute.common.model.activityselect.ActivityInfo;
import cn.com.duiba.nezha.compute.common.model.activityselect.BetaDistribution;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonInterval;
import cn.com.duiba.nezha.compute.common.model.activityselect.WilsonPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivitySelector {
    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);
    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>(){

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return c2.score - c1.score >= 0.0 ? 1 : -1;
        }
    };

    public static int getCoef(double hisRequest, double request, double hisSend, double send) {
        int coef = 1;
        int i = 1;
        int j = 1;
        if (request < 0.0) {
            for (i = 1; i < 144 && !((request += hisRequest / 144.0) > 0.0); ++i) {
            }
        }
        if (send < 0.0) {
            for (j = 1; j < 144 && !((send += hisSend / 144.0) > 0.0); ++j) {
            }
        }
        return coef += Math.max(i, j);
    }

    public static List<ActivityInfo> match(List<ActivityInfo> activityInfos, int topn) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        PriorityQueue<MatchInfo> candis = new PriorityQueue<MatchInfo>(activityInfos.size(), iComparator);
        for (ActivityInfo activity : activityInfos) {
            double request = 0.0;
            double send = 0.0;
            int co = 1;
            request = activity.request.globalVal - activity.lastRequest.globalVal;
            send = activity.send.globalVal - activity.lastSend.globalVal;
            co = ActivitySelector.getCoef(activity.request.globalVal, request, activity.send.globalVal, send);
            double lastVal = activity.hisSend.globalVal;
            activity.hisSend.globalVal = lastVal > (double)Constant.MAX_HIS_VAL ? (activity.hisSend.globalVal + send) / (double)Constant.DISCOUNT : activity.hisSend.globalVal + (send += (double)co * activity.send.globalVal / 144.0);
            activity.hisRequest.globalVal = lastVal > (double)Constant.MAX_HIS_VAL ? (activity.hisRequest.globalVal + request) / (double)Constant.DISCOUNT : activity.hisRequest.globalVal + (request += (double)co * activity.request.globalVal / 144.0);
            request = activity.request.appVal - activity.lastRequest.appVal;
            send = activity.send.appVal - activity.lastSend.appVal;
            co = ActivitySelector.getCoef(activity.request.appVal, request, activity.send.appVal, send);
            lastVal = activity.hisSend.appVal;
            activity.hisSend.appVal = lastVal > (double)Constant.MAX_HIS_VAL ? (activity.hisSend.appVal + send) / (double)Constant.DISCOUNT : activity.hisSend.appVal + (send += (double)co * activity.send.appVal / 144.0);
            activity.hisRequest.appVal = lastVal > (double)Constant.MAX_HIS_VAL ? (activity.hisRequest.appVal + request) / (double)Constant.DISCOUNT : activity.hisRequest.appVal + (request += (double)co * activity.request.appVal / 144.0);
            request = activity.request.slotVal - activity.lastRequest.slotVal;
            send = activity.send.slotVal - activity.lastSend.slotVal;
            co = ActivitySelector.getCoef(activity.request.slotVal, request, activity.send.slotVal, send);
            lastVal = activity.hisSend.slotVal;
            activity.hisSend.slotVal = lastVal > (double)Constant.MAX_HIS_VAL ? (activity.hisSend.slotVal + send) / (double)Constant.DISCOUNT : activity.hisSend.slotVal + (send += (double)co * activity.send.slotVal / 144.0);
            activity.hisRequest.slotVal = lastVal > (double)Constant.MAX_HIS_VAL ? (activity.hisRequest.slotVal + request) / (double)Constant.DISCOUNT : activity.hisRequest.slotVal + (request += (double)co * activity.request.slotVal / 144.0);
            int limit = topn--;
            if (activity.hisRequest.globalVal < 100.0) {
                if (activityInfos.size() > limit) {
                    if (!(Math.random() < 0.001)) continue;
                    result.add(activity);
                    continue;
                }
                result.add(activity);
                --topn;
                continue;
            }
            double slotScore = WilsonInterval.wilsonCalc((long)((long)activity.hisSend.slotVal / 3L), (long)((long)activity.hisRequest.slotVal * 3L)).lowerBound;
            double globalScore = WilsonInterval.wilsonCalc((long)((long)activity.hisSend.globalVal / 3L), (long)((long)activity.hisRequest.globalVal * 3L)).lowerBound;
            double appScore = WilsonInterval.wilsonCalc((long)((long)activity.hisSend.appVal / 3L), (long)((long)activity.hisRequest.appVal * 3L)).lowerBound;
            double coef = 0.0;
            double matchscore = 0.0;
            double sconfidence = Math.min(activity.hisSend.slotVal / 500.0, 1.0);
            double aconfidence = Math.min(activity.hisSend.appVal / 1000.0, 1.0);
            double gconfidence = Math.min(activity.hisSend.globalVal / 500.0, 1.0);
            matchscore = sconfidence * slotScore + (1.0 - sconfidence) * aconfidence * appScore * 0.9 + (1.0 - (1.0 - sconfidence) * aconfidence) * globalScore * 0.7 * Math.max(0.5, gconfidence);
            MatchInfo info = new MatchInfo();
            info.act = activity;
            info.score = matchscore;
            candis.add(info);
        }
        int size = candis.size();
        for (int i = 0; i < topn && i < size; ++i) {
            result.add(((MatchInfo)candis.poll()).act);
        }
        return result;
    }

    public static ActivityInfo select(List<ActivityInfo> activityInfos) {
        ArrayList<Double> rewards = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> alphas = new ArrayList<Double>();
        ArrayList<Double> betas = new ArrayList<Double>();
        double decay = Constant.DECAY;
        HashMap<Long, RankInfo> mMap = new HashMap<Long, RankInfo>();
        double maxG = 0.1;
        double maxH = 0.1;
        double maxA = 0.1;
        int size = activityInfos.size();
        activityInfos = ActivitySelector.match(activityInfos, 50);
        for (ActivityInfo act : activityInfos) {
            double hrpm;
            double arpm;
            double grpm;
            RankInfo info = mMap.containsKey(act.activityId) ? (RankInfo)mMap.get(act.activityId) : new RankInfo();
            info.grpm = grpm = act.hisRequest.globalVal > 0.0 ? act.hisSend.globalVal / act.hisRequest.globalVal : 0.0;
            info.gexp = act.hisRequest.globalVal;
            maxG = Math.max(grpm, maxG);
            info.arpm = arpm = act.hisRequest.appVal > 0.0 ? act.hisSend.appVal / act.hisRequest.appVal : 0.0;
            info.aexp = act.hisRequest.appVal;
            if (info.hexp > 50.0) {
                maxA = Math.max(arpm, maxA);
            }
            info.hrpm = hrpm = act.hisRequest.slotVal > 0.0 ? act.hisSend.slotVal / act.hisRequest.slotVal : 0.0;
            info.hexp = act.hisRequest.slotVal;
            if (info.hexp > 50.0) {
                maxH = Math.max(hrpm, maxH);
            }
            mMap.put(act.activityId, info);
        }
        ArrayList<ActivityInfo> candiList = new ArrayList<ActivityInfo>();
        for (ActivityInfo act : activityInfos) {
            if (act.request.globalVal > 0.0) {
                double reward = Constant.MIN_REWARD;
                double confidence = act.hisSend.slotVal >= 200.0 ? 1.0 : act.hisSend.slotVal / 200.0;
                reward = (1.0 - confidence) * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).grpm, maxG, 1.0) + confidence * ActivitySelector.normlize(((RankInfo)mMap.get((Object)Long.valueOf((long)act.activityId))).hrpm, maxH, 1.0);
                reward = Math.max(reward, Constant.MIN_REWARD);
                act.reward = act.reward * decay + reward;
                act.count = act.count * decay + 1.0;
                if (confidence > 0.1 && act.count < 20.0) {
                    act.reward = 20.0 * reward;
                    act.count = 20.0;
                }
                act.alpha = 1.5 + act.reward;
                act.beta = 2.0 + (act.count - act.reward);
            }
            rewards.add(act.reward);
            counts.add(act.count);
            alphas.add(act.alpha);
            betas.add(act.beta);
            candiList.add(act);
        }
        int numMachines = candiList.size();
        ActivityInfo result = (ActivityInfo)candiList.get(ActivitySelector.selectMachine(alphas, betas, numMachines));
        if (System.currentTimeMillis() - result.updateTime > 60000L) {
            result.isUpdate = true;
        }
        mMap.clear();
        result.lastRequest.appVal = result.request.appVal;
        result.lastRequest.slotVal = result.request.slotVal;
        result.lastRequest.globalVal = result.request.globalVal;
        result.lastSend.appVal = result.send.appVal;
        result.lastSend.slotVal = result.send.slotVal;
        result.lastSend.globalVal = result.send.globalVal;
        return result;
    }

    public static void print(ActivityInfo act) {
        System.out.println("-----------" + act.activityId + "-----------");
        System.out.println("request = " + act.request.slotVal + "\t" + act.request.appVal + "\t" + act.request.globalVal);
        System.out.println("send = " + act.send.slotVal + "\t" + act.send.appVal + "\t" + act.send.globalVal);
        System.out.println("lastRequest = " + act.lastRequest.slotVal + "\t" + act.lastRequest.appVal + "\t" + act.lastRequest.globalVal);
        System.out.println("lastSend = " + act.lastSend.slotVal + "\t" + act.lastSend.appVal + "\t" + act.lastSend.globalVal);
        System.out.println("hisRequest = " + act.hisRequest.slotVal + "\t" + act.hisRequest.appVal + "\t" + act.hisRequest.globalVal);
        System.out.println("hisSend = " + act.hisSend.slotVal + "\t" + act.hisSend.appVal + "\t" + act.hisSend.globalVal);
    }

    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }

    private static int selectMachine(List<Double> alphas, List<Double> betas, int numMachines) {
        int selectMachine = 0;
        double maxTheta = 0.0;
        for (int i = 0; i < numMachines; ++i) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            if (!(theta > maxTheta)) continue;
            maxTheta = theta;
            selectMachine = i;
        }
        return selectMachine;
    }

    private double getCtr(double exp, double clk) {
        return exp > 0.0 ? clk / exp : 0.0;
    }

    private double sum(List<Long> list) {
        double sum = 0.0;
        for (Long val : list) {
            sum += (double)val.longValue();
        }
        return sum;
    }

    public static double wilsonRoofLeft(Double ratio, Double num) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        long fenzi = (long)(ratio * num);
        long fenmu = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonRoofRight(Double num, Double ratio) {
        if (ratio == null || num == null) {
            return 0.0;
        }
        if (ratio == 0.0) {
            ratio = 1.0E-8;
        }
        long fenmu = (long)(num / ratio);
        long fenzi = num.longValue();
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.upperBound;
    }

    public double wilsonBottom(Long fenzi, Long fenmu) {
        if (fenzi == null || fenmu == null) {
            return 0.0;
        }
        WilsonPair pair = WilsonInterval.wilsonCalc(fenzi, fenmu);
        return pair.lowerBound;
    }

    private static ActivitySelector getInstance() {
        return SingletonHolder.instance;
    }

    public static class SingletonHolder {
        private static final ActivitySelector instance = new ActivitySelector();
    }

    static class MatchInfo {
        double score;
        ActivityInfo act;

        MatchInfo() {
        }
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double hrpm;
        double hexp;
        double arpm;
        double aexp;

        RankInfo() {
        }
    }

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2L;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;

        Constant() {
        }
    }
}

