/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.common.util.conf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    protected ConfProperties(String filePath) throws FileNotFoundException {
        InputStream inStream = ConfProperties.class.getResourceAsStream(filePath);
        try {
            this.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NullPointerException("Failed to load config file: " + filePath + ", error: " + e.getMessage());
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int getInt(String propertyName, int defaultValue) {
        int propertyValue = defaultValue;
        String valueStr = this.getProperty(propertyName);
        try {
            propertyValue = Integer.parseInt(valueStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyValue;
    }

    public float getFloat(String propertyName, float defaultValue) {
        float propertyValue = defaultValue;
        String valueStr = this.getProperty(propertyName);
        try {
            propertyValue = Float.parseFloat(valueStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyValue;
    }

    public double getDouble(String propertyName, double defaultValue) {
        double propertyValue = defaultValue;
        String valueStr = this.getProperty(propertyName);
        try {
            propertyValue = Double.parseDouble(valueStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyValue;
    }
}

