package cn.com.duiba.nezha.compute.deploy;

import cn.com.duiba.nezha.compute.alg.FM;
import cn.com.duiba.nezha.compute.api.dto.AdvertModelEntity;
import cn.com.duiba.nezha.compute.api.enums.ModelKeyEnum;
import cn.com.duiba.nezha.compute.biz.bo.AdvertCtrLrModelBo;
import cn.com.duiba.nezha.compute.common.enums.DateStyle;
import cn.com.duiba.nezha.compute.common.util.DateUtil;

import java.io.*;
import java.util.*;

public class PreviewPredictSaveLocal {
    public static void main(String[] args) {
        System.out.println("s start time = " + DateUtil.getCurrentTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        File f = new File("/home/db_dlp/mengxiangxuan/auto_spread/slot_ad_cvr.txt");
        try {

            BufferedReader readerslotid = new BufferedReader(new FileReader("/home/db_dlp/mengxiangxuan/auto_spread/slot_min_arpu.csv"));
            readerslotid.readLine();
            String slotline;
            ArrayList<String[]> slotidlist = new ArrayList<String[]>();

            while((slotline = readerslotid.readLine()) != null) {
                String[] item = slotline.split(",");
                slotidlist.add(item);
            }


            AdvertModelEntity entityCTR = AdvertCtrLrModelBo.getCTRModelByKeyFromMD(ModelKeyEnum.FM_CTR_MODEL_v003.getIndex());
            AdvertModelEntity entityCVR = AdvertCtrLrModelBo.getCTRModelByKeyFromMD(ModelKeyEnum.FM_CVR_MODEL_v003.getIndex());
            FM fmModelCTR = new FM(entityCTR);
            FM fmModelCVR = new FM(entityCVR);

            int slotSize=slotidlist.size();
            for(int slot = 0; slot < slotSize; ++slot) {
                System.out.println("go " + slot);
                BufferedReader readerAdF = new BufferedReader(new FileReader("/home/db_dlp/mengxiangxuan/auto_spread/ad_info.csv"));
                BufferedReader readerSnF = new BufferedReader(new FileReader("/home/db_dlp/mengxiangxuan/auto_spread/scene_info.csv"));

                String slotid = slotidlist.get(slot)[0];
                String arpu = slotidlist.get(slot)[1];
                Double min_arpu=Double.parseDouble(arpu);
                System.out.println("slotid " + slotid);

                readerAdF.readLine();
                String Adline;
                ArrayList<Map> adFeatrueMaplist = new ArrayList<Map>();

                while((Adline = readerAdF.readLine()) != null) {
                    String[] item = Adline.split("\\|");
                    if (item[0].equals(slotid)) {
                        Map<String,String> adfeatrueMap = new HashMap<String,String>();
                        adfeatrueMap.put("f108001", item[0].replace(".0", ""));
                        adfeatrueMap.put("f101001", item[1].replace(".0", ""));
                        adfeatrueMap.put("f106001", item[2].replace(".0", ""));
                        adfeatrueMap.put("f102001", item[3]);
                        adfeatrueMap.put("fee", item[4]);
                        adFeatrueMaplist.add(adfeatrueMap);
                    }
                }

                System.out.println("ad size " + adFeatrueMaplist.size());

                readerSnF.readLine();
                ArrayList<Map> snFeatrueMaplist = new ArrayList<Map>();
                String Snline;
                while((Snline = readerSnF.readLine()) != null) {
                    String[] item = Snline.split("\\|");
                    if (item[1].equals(slotid)) {
                        Map<String,String> slotfeatrueMap = new HashMap<String,String>();
                        slotfeatrueMap.put("f201001", item[0].replace(".0", ""));
                        slotfeatrueMap.put("f108001", item[1].replace(".0", ""));
                        slotfeatrueMap.put("f301001", item[2].replace(".0", ""));
                        slotfeatrueMap.put("f501001", item[3].replace(".0", ""));
                        slotfeatrueMap.put("f611001", item[4].replace(".0", ""));
                        slotfeatrueMap.put("f110001", item[5].replace(".0", ""));
                        slotfeatrueMap.put("f502001", item[6].replace(".0", ""));
                        slotfeatrueMap.put("f505001", item[7].replace(".0", ""));
                        slotfeatrueMap.put("f502002", item[8].replace(".0", ""));
                        slotfeatrueMap.put("f601001", item[9].replace(".0", ""));
                        slotfeatrueMap.put("f603001", item[10].replace(".0", ""));
                        slotfeatrueMap.put("f602001", item[11].replace(".0", ""));
                        slotfeatrueMap.put("f604001", item[12].replace(".0", ""));
                        slotfeatrueMap.put("f605001", item[13].replace(".0", ""));
                        slotfeatrueMap.put("f606001", item[14].replace(".0", ""));
                        slotfeatrueMap.put("f607001", item[15].replace(".0", ""));
                        slotfeatrueMap.put("f608001", item[16].replace(".0", ""));
                        slotfeatrueMap.put("f609001", item[17].replace(".0", ""));
                        slotfeatrueMap.put("f503001", item[18].replace(".0", ""));
                        slotfeatrueMap.put("f306001", item[19].replace(".0", ""));
                        snFeatrueMaplist.add(slotfeatrueMap);
                    }
                }

                System.out.println("sn size " + snFeatrueMaplist.size());
                Map<String,Long> slotAdCTRRetCntMap = new HashMap<String,Long>();
                Map<String,Long> slotAdCVRRetCntMap = new HashMap<String,Long>();
                Map<String, Double> slotAdCTRRetSumMap = new HashMap<String, Double>();
                Map<String, Double> slotAdCVRRetSumMap = new HashMap<String, Double>();
                for(Map i:snFeatrueMaplist) {
                    for(Map j:adFeatrueMaplist) {
                        Map<String, String> tempfeatrueMap = new HashMap<String, String>(i);
                        tempfeatrueMap.put("f101001", (String)j.get("f101001"));
                        tempfeatrueMap.put("f106001", (String)j.get("f106001"));
                        tempfeatrueMap.put("f102001", (String)j.get("f102001"));

                        Double retCTR = fmModelCTR.predict(tempfeatrueMap);
                        Double fee=Double.parseDouble((String) j.get("fee"));
                        Double preArpu=retCTR*fee;
                        if (preArpu>min_arpu) {
                            Double retCVR = fmModelCVR.predict(tempfeatrueMap);
                            String slotAdkey = tempfeatrueMap.get("f108001") + "_" + tempfeatrueMap.get("f101001");
                            if (slotAdCVRRetCntMap.get(slotAdkey) != null) {
                                slotAdCTRRetCntMap.put(slotAdkey, slotAdCTRRetCntMap.get(slotAdkey) + 1L);
                                slotAdCVRRetCntMap.put(slotAdkey, slotAdCVRRetCntMap.get(slotAdkey) + 1L);
                            } else {
                                slotAdCTRRetCntMap.put(slotAdkey, 1L);
                                slotAdCVRRetCntMap.put(slotAdkey, 1L);
                            }

                            if (slotAdCVRRetSumMap.get(slotAdkey) != null) {
                                slotAdCTRRetSumMap.put(slotAdkey, slotAdCTRRetSumMap.get(slotAdkey) + retCTR);
                                slotAdCVRRetSumMap.put(slotAdkey, slotAdCVRRetSumMap.get(slotAdkey) + retCVR);
                            } else {
                                slotAdCTRRetSumMap.put(slotAdkey, retCTR);
                                slotAdCVRRetSumMap.put(slotAdkey, retCVR);
                            }
                        }

                    }
                }

                for (String i:slotAdCVRRetCntMap.keySet()) {
                    Double stdCtr = slotAdCTRRetSumMap.get(i) / (double)slotAdCTRRetCntMap.get(i);
                    Double stdCvr = slotAdCVRRetSumMap.get(i) / (double)slotAdCVRRetCntMap.get(i);
                    String result=i+","+String.format("%.6f", stdCtr)+","+String.format("%.6f", stdCvr);
                    BufferedWriter output = new BufferedWriter(new FileWriter(f, true));
                    output.write(result);
                    output.write("\r\n");
                    output.flush();
                    output.close();

                }
                System.out.println("------------------------------------------------------------------------------------- ");
            }
        } catch (Exception var26) {
            var26.printStackTrace();
        }

        System.out.println("s end time = " + DateUtil.getCurrentTime(DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
    }
}

