package cn.com.duiba.nezha.engine.api.enums;

public enum ModelKeyEnum {

    // FFM_CTR
    FFM_CTR_MODEL_V001("mid_ftrl_ffm_ctr_v001", ModelType.FFM, true),
    FFM_CTR_MODEL_V002("mid_ftrl_ffm_ctr_v002", ModelType.FFM, true),
    FFM_CTR_MODEL_V004("mid_ftrl_ffm_ctr_v004", ModelType.FFM, true),

    //FFM_CVR
    FFM_BCVR_MODEL_V001("mid_ftrl_ffm_bcvr_v001", ModelType.FFM, true),
    FFM_BCVR_MODEL_V002("mid_ftrl_ffm_bcvr_v002", ModelType.FFM, true),
    FFM_BCVR_MODEL_V004("mid_ftrl_ffm_bcvr_v004", ModelType.FFM, true),

    //FM_CTR
    FM_CTR_MODEL_v003("mid_fm_ctr_v003", ModelType.FM, false),
    FM_CTR_MODEL_v603("mid_fm_ctr_v603", ModelType.FM, false),

    //FM_CVR
    FM_BCVR_MODEL_v003("mid_fm_bcvr_v003", ModelType.FM, false),
    FM_BCVR_MODEL_v603("mid_fm_be_cvr_v603", ModelType.FM, false),

    //FM_CTR
    FTRL_FM_CTR_MODEL_v002("mid_ftrl_fm_ctr_v002", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v004("mid_ftrl_fm_ctr_v004", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v007("mid_ftrl_fm_ctr_v007", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v009("mid_ftrl_fm_ctr_v009", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v010("mid_ftrl_fm_ctr_v010", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v011("mid_ftrl_fm_ctr_v011", ModelType.FM, true),


    FTRL_FM_CTR_MODEL_v701("mid_ftrl_fm_ctr_v701", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v702("mid_ftrl_fm_ctr_v702", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v703("mid_ftrl_fm_ctr_v703", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v704("mid_ftrl_fm_ctr_v704", ModelType.FM, true),


    //FM_CVR
    FTRL_FM_BCVR_MODEL_v002("mid_ftrl_fm_bcvr_v002", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v004("mid_ftrl_fm_bcvr_v004", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v007("mid_ftrl_fm_bcvr_v007", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v009("mid_ftrl_fm_bcvr_v009", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v010("mid_ftrl_fm_bcvr_v010", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v011("mid_ftrl_fm_bcvr_v011", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v012("mid_ftrl_fm_bcvr_v012", ModelType.FM, true),

    FTRL_FM_BCVR_MODEL_v701("mid_ftrl_fm_bcvr_v701", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v702("mid_ftrl_fm_bcvr_v702", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v703("mid_ftrl_fm_bcvr_v703", ModelType.FM, true),
    FTRL_FM_BCVR_MODEL_v704("mid_ftrl_fm_bcvr_v704", ModelType.FM, true),


    FTRL_FM_CVR_MODEL_v611("mid_ftrl_fm_cvr_v611", ModelType.FM, true),
    FTRL_FM_CVR_MODEL_v612("mid_ftrl_fm_cvr_v612", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v611("mid_ftrl_fm_ctr_v611", ModelType.FM, true),
    FTRL_FM_CTR_MODEL_v612("mid_ftrl_fm_ctr_v612", ModelType.FM, true),

    //FM_CODER
    FTRL_CODER_CTR_V001("mid_ftrl_coder_ctr_v001", ModelType.CODER, true),
    FTRL_CODER_BCVR_V001("mid_ftrl_coder_bcvr_v001", ModelType.CODER, true),

    //增值场景 CTR 模型
    ZZ_FTRL_FM_CTR_MODEL_v001("zz_mid_ftrl_fm_ctr_v001", ModelType.FM, true),
    ZZ_FTRL_FM_CTR_MODEL_v002("zz_mid_ftrl_fm_ctr_v002", ModelType.FM, true),
    ;
    private String index;

    private ModelType modelType;

    private Boolean online;

    public String getIndex() {
        return index;
    }

    public ModelType getModelType() {
        return modelType;
    }

    public Boolean getOnline() {
        return online;
    }

    ModelKeyEnum(String index, ModelType modelType, Boolean online) {
        this.index = index;
        this.modelType = modelType;
        this.online = online;
    }
}
