package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

import static java.util.stream.Collectors.toMap;

/**
 * 策略类型
 */
public enum InteractAdvertAlgEnum implements AdvertAlgEnum {

    BTM_AND_SC_6(106, "小时维度"),
    BTM_AND_SC_7(107, "小时维度,优先选择素材"),

    BTM_AND_PC_6(206, "FM模型,预估纠偏"),
    BTM_AND_PC_7(207, "FM模型,预估纠偏,分布重构"),
    BTM_AND_PC_10(210, "小时维度,优先选择素材,FM 模型"),
    BTM_AND_PC_13(213, "FM 多维度质量分"),
    BTM_AND_PC_17(217, "FM模型+智能策略"),
    BTM_AND_PC_20(220, "用户行为偏好"),

    BTM_AND_PC_23(223, "在线学习模型V002"),
    BTM_AND_PC_24(224, "在线学习模型V003"),
    BTM_AND_PC_26(226, "在线学习-预估值权重优化"),
    BTM_AND_PC_27(227, "app安装列表优化模型"),//
    BTM_AND_PC_28(228, "用户行为-计数特征"),
    BTM_AND_PC_29(229, "FM模型后端优化"),
    BTM_AND_PC_31(231, "在线学习批量训练"),
    BTM_AND_PC_34(234, "新素材推荐"),
    BTM_AND_PC_35(235, "纠偏2"),
    BTM_AND_PC_36(236, "纠偏3"),
    BTM_AND_PC_37(237, "广告位媒体标签"),
    BTM_AND_PC_38(238, "素材图片特征"),
    BTM_AND_PC_41(241, "深度学习fnn2"),
    BTM_AND_PC_42(242, "深度学习deepFm2"),
    BTM_AND_PC_44(244, "深度学习dcn2"),
    BTM_AND_PC_45(245, "深度学习dcn3"),
    BTM_AND_PC_46(246, "深度学习xDeepFm2"),
    BTM_AND_PC_47(247, "深度学习xDeepFm3"),
    BTM_AND_PC_39(239, "ADX预发模型"),


    BTM_AND_PC_48(248, "ffm002"),
    BTM_AND_PC_49(249, "ffm003"),

    BTM_AND_PC_50(250, "多任务在线学习-1"),
    BTM_AND_PC_51(251, "多任务在线学习-2"),

    BTM_AND_PC_52(252, "素材改造-在线版"),

    BTM_AND_PC_53(253, "深度学习xDeepFm4"),

    BTM_AND_PC_54(254, "多任务深度学习-1"),
    BTM_AND_PC_55(255, "多任务深度学习-2"),
    BTM_AND_PC_56(256, "多任务深度学习-3"),
    BTM_AND_PC_57(257, "多任务深度学习-4"),

    BTM_AND_PC_58(258, "ffm001"),
    BTM_AND_PC_59(259, "ffm004"),
    BTM_AND_PC_60(260, "多任务在线学习-3"),

    BTM_AND_PC_61(261, "深度学习xDeepFm5"),
    BTM_AND_PC_62(262, "深度学习xDeepFm6"),
    BTM_AND_PC_63(263, "重复资源-1"),
    BTM_AND_PC_64(264, "重复资源-2"),
    BTM_AND_PC_65(265, "new_trade"),
    BTM_AND_PC_66(266, "ad_app_p"),
    BTM_AND_PC_67(267, "深度端到端deepFm-1"),
    BTM_AND_PC_68(268, "深度端到端deepFm-2"),
    BTM_AND_PC_69(269, "深度端到端deepFm-3"),
    BTM_AND_PC_70(270, "深度端到端deepFm-4"),
    BTM_AND_PC_71(271, "深度端到端deepFm-5"),

    ;


    private Integer type;

    private String desc;

    private static final Map<String, InteractAdvertAlgEnum> CACHE = Arrays.stream(InteractAdvertAlgEnum.values())
            .collect(toMap(AdvertAlgTypeEnum -> AdvertAlgTypeEnum.getType().toString(), Function.identity()));

    InteractAdvertAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AdvertAlgEnum get(String strategyId) {
        return CACHE.get(strategyId);
    }


    @Override
    public Integer getType() {

        return type;
    }

    public String getDesc() {
        return desc;
    }


}
