package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import static java.util.stream.Collectors.toMap;

public enum EncourageAdvertAlgEnum implements AdvertAlgEnum {

    ENCOURAGE_AND_PC_1(401, "PC,增值广告"),
    ENCOURAGE_AND_PC_2(402, "PC,增值广告");

    private Integer type;

    private String desc;


    EncourageAdvertAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<String, EncourageAdvertAlgEnum> CACHE = Arrays.stream(EncourageAdvertAlgEnum.values())
            .collect(HashMap::new,(m,v)->m.put(v.getType().toString(),v),HashMap::putAll);

    public static AdvertAlgEnum get(String strategyId) {
        return CACHE.get(strategyId);
    }

    public String getDesc() {
        return this.desc;
    }

    @Override
    public Integer getType() {
        return this.type;
    }

}
