package cn.com.duiba.nezha.engine.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Optional;

/**
 * app参数
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AppDto.java , v 0.1 2017/6/8 下午6:55 ZhouFeng Exp $
 */
@Setter
@Getter
public class AppDto implements Serializable {
    private static final long serialVersionUID = -6117135769384442700L;

    private Long appId;

    /**
     * app类型
     */
    private String appCategory;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 广告位宽度
     */
    private Integer slotWidth;

    /**
     * 广告位高度
     */
    private Integer slotHeight;

    /**
     * 广告位类型
     */
    private Integer slotType;

    /**
     * 媒体类型，0非美团，1-美团
     */
    private Integer adxMediaType;

    /**
     * 广告位标签父ID
     */
    private String slotIndustryTagPid;

    /**
     * 广告位标签ID
     */
    private String slotIndustryTagId;

    /**
     * 媒体标签父ID
     */
    private String appIndustryTagPid;

    /**
     * 媒体标签ID
     */
    private String appIndustryTagId;

    /**
     * 流量标签ID
     */
    private String trafficTagId;

    /**
     * 流量标签父ID
     */
    private String trafficTagPid;

    /**
     * 流量dmp人群标签
     */
    private String appUserInterest;

    /**
     * 流量基础标签
     * @return
     */
    private String imeiBasicTags;

    /**
     * 美团用的，1-表示5张rankScore最高的券， 2-表示5个行业最高rankScore的券
     */
    private Integer adVirtue;

    public Integer getAdxMediaType() {
        return Optional.ofNullable(adxMediaType).orElse(0);
    }


}
