package cn.com.duiba.nezha.engine.api.dto;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.*;


/**
 * Created by lwj on 2016/8/30.
 * 请求广告结果
 */
public class AdvertNewDto implements Serializable {

    private static final long serialVersionUID = 523827427472072954L;

    private static final String DEFULT_NEW_TRADE_NAME = "未知";

    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 配置包id
     */
    private Long packageId;

    /**
     * 包类型
     */
    private Integer packageType;

    /**
     * 定向媒体类型
     */
    private Integer targetAppLimit;

    /**
     * 是否是强定向
     */
    private Boolean strongTarget;

    /**
     * 广告出价
     */
    private Long fee;

    /**
     * 对该用户的最近发放次数
     */
    private Long launchCountToUser;

    /**
     * 计费类型 1.CPC 2.CPA
     */
    private Integer chargeType;

    /**
     * 推广链接标签
     */
    private Set<String> spreadTags;

    /**
     * 广告主账号
     */
    private String accountId;

    /**
     * 特征标签
     */
    private String matchTagNums;

    /**
     * 素材列表
     */
    private Set<MaterialDto> materials;

    /**
     * 素材及其对应的标签列表
     */
    private Map<Long, Set<String>> materialMapNew;

    /**
     * 标签权重
     */
    private Double weight;

    /**
     * 0点到当前每小时预算（不包括当前小时）
     */
    private List<Double> hourlyBudgetFees;

    /**
     * 0点到当前每小时预算发券（不包括当前小时）
     */
    private List<Double> hourlyBudgetCounts;

    /**
     * 定向配置总预算
     */
    private Long packageBudget;

    /**
     * 折扣率
     */
    private Double discountRate;

    /**
     * 行业标签
     */
    private String industryTag;

    /**
     * 行业标签(新)
     */
    private String industryTagNew;

    /**
     * 全局转换成本
     */
    private Long convertCost;

    /**
     * 不同的转化类型对应的成本
     */
    private Long convertTypeCost;

    /**
     * 备选广告id列表
     */
    private Set<Long> backupAdvertIds;

    /**
     * 是否需要扶持，true-需要扶持，false-不需要扶持
     */
    private Boolean supportStatus;

    /**
     * 扶持广告是否AB分流
     */
    private Boolean isSupportShunt;

    /**
     * 考核成本
     */
    private Long assessCost;

    /**
     * 活动引擎是否需要低arpu值券:1.需要 0.不需要
     */
    private Integer canReplaceLowArpu;

    /**
     * 新行业标签
     */
    private String newTradeTagNum;

    /**
     * 新行业标签对应的 新行业id
     *
     * @param builder
     */
    private String newTradeTagId;


    private String resourceTagNum;

    /**
     * 优化目标
     */
    private Integer cvrType;

    /**
     * 深度优化目标
     */
    private Integer depthCvrType;

    /**
     * 投放目标类型，1-消耗优先、2-成本优先、3-均衡投放、4-人工定向
     * PutTargetTypeEnum
     */
    private Integer releaseTarget;

    /**
     * 重点媒体转化出价
     */
    private Long importantAppFee;

    /**
     * 消耗类型0：加速投放，1：匀速投放
     */
    private Integer budgetSmooth;

    /**
     * 分媒体出价 来源类型
     * 以后涉及 单个媒体 有不同的出价 全部由该字段来表示
     * 0 表示非 分媒体出价 ！0可以参考下面枚举
     * {@link cn.com.tuia.advert.enums.DisAppFeeTypeEnum}
     */
    private Integer disAppFeeType;

    /**
     * 是否在底价白名单中 true-是底价白名单 false- 是普通广告
     */
    private Boolean floorPriceWhilteAdvert;

    /**
     * 自动竞价类型 0-未开启自动竞价，1-CPC深度优化模式，2-CPC自动抢量模式
     * @CPCAutoBiddingTypeEnum
     */
    private Integer autoBiddingType;

    /**
     * 与流量命中的人群定向标签
     */
    private Set<String> hitUserInterest;

    /**
     * 新素材&素材测试ID
     */
    private Long testMaterialId;

    /**
     * 新行业名称::广告二级行业标签对应的new_trade名称
     */
    private String newTradeName;

    /**
     * 广告的日预算
     */
    private Long advertBudget;

    /**
     * KA扶持广告相关信息
     */
    private SupportAdvertInfoDto supportAdvertInfoDto;

    /**
     * 出单率，为空则没有
     */
    private Integer outOrderRate;

    /**
     * 展示广告多张券白名单，1-在白名单，0/null不在白名单
     */
    private Integer inShowWhite;

    /**
     * ocpc底价
     */
    private Long ocpcReversePrice;

    /**
     * 是否为拓量广告:0/null-ocpc非拓量配置、 1-ocpc拓量配置；
     */
    private Integer expandAdvert;

    /**
     * md5-落地页url集合
     */
    private List<String> promoteList;

    /**
     * 是否为人群拓量广告:0/null-非人群拓量配置、 1-人群拓量配置；
     */
    private Integer peopleExpand;

    /** 是否开启探索 */
    private Boolean enabledExplore;


    private AdvertNewDto(Builder builder) {
        setAdvertId(builder.advertId);
        setPackageId(builder.packageId);
        setPackageType(builder.packageType);
        setTargetAppLimit(builder.targetAppLimit);
        setStrongTarget(builder.strongTarget);
        setFee(builder.fee);
        setLaunchCountToUser(builder.launchCountToUser);
        setChargeType(builder.chargeType);
        setSpreadTags(builder.spreadTags);
        setAccountId(builder.accountId);
        setMatchTagNums(builder.matchTagNums);
        setMaterials(builder.materials);
        setMaterialMapNew(builder.materialMapNew);
        setWeight(builder.weight);
        setHourlyBudgetFees(builder.hourlyBudgetFees);
        setHourlyBudgetCounts(builder.hourlyBudgetCounts);
        setPackageBudget(builder.packageBudget);
        setDiscountRate(builder.discountRate);
        setIndustryTag(builder.industryTag);
        setIndustryTagNew(builder.industryTagNew);
        setConvertCost(builder.convertCost);
        setConvertTypeCost(builder.convertTypeCost);
        setBackupAdvertIds(builder.backupAdvertIds);
        setSupportStatus(builder.supportStatus);
        setAssessCost(builder.assessCost);
        setNewTradeTagNum(builder.newTradeTagNum);
        setCvrType(builder.cvrType);
        setDepthCvrType(builder.depthCvrType);
        setBudgetSmooth(builder.budgetSmooth);
        setFloorPriceWhilteAdvert(builder.floorPriceWhilteAdvert);
    }

    public Integer getPeopleExpand() {
        return peopleExpand;
    }

    public void setPeopleExpand(Integer peopleExpand) {
        this.peopleExpand = peopleExpand;
    }

    public List<String> getPromoteList() {
        return promoteList;
    }

    public void setPromoteList(List<String> promoteList) {
        this.promoteList = promoteList;
    }

    public Long getOcpcReversePrice() {
        return ocpcReversePrice;
    }

    public void setOcpcReversePrice(Long ocpcReversePrice) {
        this.ocpcReversePrice = ocpcReversePrice;
    }

    public Integer getExpandAdvert() {
        return Optional.ofNullable(expandAdvert).orElse(0);
    }

    public void setExpandAdvert(Integer expandAdvert) {
        this.expandAdvert = expandAdvert;
    }

    public Integer getInShowWhite() {
        return inShowWhite;
    }

    public void setInShowWhite(Integer inShowWhite) {
        this.inShowWhite = inShowWhite;
    }

    public Integer getOutOrderRate() {
        return outOrderRate;
    }

    public void setOutOrderRate(Integer outOrderRate) {
        this.outOrderRate = outOrderRate;
    }

    public Long getAdvertBudget() {
        return advertBudget;
    }

    public void setAdvertBudget(Long advertBudget) {
        this.advertBudget = advertBudget;
    }

    public SupportAdvertInfoDto getSupportAdvertInfoDto() {
        return supportAdvertInfoDto;
    }

    public void setSupportAdvertInfoDto(SupportAdvertInfoDto supportAdvertInfoDto) {
        this.supportAdvertInfoDto = supportAdvertInfoDto;
    }

    public String getNewTradeName() {

        return StringUtils.isNotBlank(newTradeName) ? newTradeName : DEFULT_NEW_TRADE_NAME;
    }

    public void setNewTradeName(String newTradeName) {
        this.newTradeName = newTradeName;
    }

    public Long getTestMaterialId() {
        return Optional.ofNullable(testMaterialId).orElse(0L);
    }

    public void setTestMaterialId(Long testMaterialId) {
        this.testMaterialId = testMaterialId;
    }

    public Set<String> getHitUserInterest() {
        return hitUserInterest;
    }

    public void setHitUserInterest(Set<String> hitUserInterest) {
        this.hitUserInterest = hitUserInterest;
    }

    public Integer getAutoBiddingType() {
        return autoBiddingType;
    }

    public void setAutoBiddingType(Integer autoBiddingType) {
        this.autoBiddingType = autoBiddingType;
    }

    public Boolean getFloorPriceWhilteAdvert() {
        return Optional.ofNullable(floorPriceWhilteAdvert).orElse(Boolean.FALSE);
    }

    public void setFloorPriceWhilteAdvert(Boolean floorPriceWhilteAdvert) {
        this.floorPriceWhilteAdvert = floorPriceWhilteAdvert;
    }

    public String getNewTradeTagId() {
        return newTradeTagId;
    }

    public void setNewTradeTagId(String newTradeTagId) {
        this.newTradeTagId = newTradeTagId;
    }

    public Integer getDisAppFeeType() {
        return Optional.ofNullable(disAppFeeType).orElse(0);
    }

    public void setDisAppFeeType(Integer disAppFeeType) {
        this.disAppFeeType = disAppFeeType;
    }


    public Integer getDepthCvrType() {
        return depthCvrType;
    }

    public void setDepthCvrType(Integer depthCvrType) {
        this.depthCvrType = depthCvrType;
    }

    public Long getImportantAppFee() {
        return Optional.ofNullable(importantAppFee).orElse(this.getConvertCost());
    }

    public Long getInitImportantAppFee(){
        return importantAppFee;
    }

    public void setImportantAppFee(Long importantAppFee) {
        this.importantAppFee = importantAppFee;
    }

    public Integer getReleaseTarget() {
        return Optional.ofNullable(releaseTarget).orElse(3);
    }

    public void setReleaseTarget(Integer releaseTarget) {
        this.releaseTarget = releaseTarget;
    }

    public String getResourceTagNum() {
        return resourceTagNum;
    }

    public void setResourceTagNum(String resourceTagNum) {
        this.resourceTagNum = resourceTagNum;
    }

    public Integer getCvrType() {
        return Optional.ofNullable(cvrType).orElse(0);
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public Long getAssessCost() {
        return assessCost;
    }

    public void setAssessCost(Long assessCost) {
        this.assessCost = assessCost;
    }

    public Boolean getSupportStatus() {
        return Optional.ofNullable(supportStatus).orElse(false);
    }

    public void setSupportStatus(Boolean supportStatus) {
        this.supportStatus = supportStatus;
    }

    public Boolean getSupportShunt() {
        return isSupportShunt;
    }

    public void setSupportShunt(Boolean supportShunt) {
        isSupportShunt = supportShunt;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getPackageType() {
        return this.packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public Integer getTargetAppLimit() {
        return this.targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public Boolean getStrongTarget() {
        return Optional.ofNullable(this.strongTarget).orElse(false);
    }

    public void setStrongTarget(Boolean strongTarget) {
        this.strongTarget = strongTarget;
    }

    public Long getPackageId() {
        return this.packageId;
    }

    public Set<Long> getBackupAdvertIds() {
        return Optional.ofNullable(backupAdvertIds).orElseGet(HashSet::new);
    }

    public void setBackupAdvertIds(Set<Long> backupAdvertIds) {
        this.backupAdvertIds = backupAdvertIds;
    }

    public Set<MaterialDto> getMaterials() {
        return Optional.ofNullable(materials).orElseGet(HashSet::new);
    }

    public void setMaterials(Set<MaterialDto> materials) {
        this.materials = materials;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public Long getLaunchCountToUser() {
        return this.launchCountToUser;
    }

    public void setLaunchCountToUser(Long launchCountToUser) {
        this.launchCountToUser = launchCountToUser;
    }

    public AdvertNewDto() {
    }

    public Long getCurrentCount() {
        long currentCount = Optional.ofNullable(this.launchCountToUser).orElse(0L) + 1;
        if (currentCount > 10) {
            currentCount = 10;
        }
        return currentCount;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Set<String> getSpreadTags() {
        return spreadTags;
    }

    public void setSpreadTags(Set<String> spreadTags) {
        this.spreadTags = spreadTags;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getMatchTagNums() {
        return matchTagNums;
    }

    public void setMatchTagNums(String matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public Map<Long, Set<String>> getMaterialMapNew() {
        return Optional.ofNullable(materialMapNew).orElseGet(HashMap::new);
    }

    public void setMaterialMapNew(Map<Long, Set<String>> materialMapNew) {
        this.materialMapNew = materialMapNew;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public List<Double> getHourlyBudgetFees() {
        return hourlyBudgetFees;
    }

    public void setHourlyBudgetFees(List<Double> hourlyBudgetFees) {
        this.hourlyBudgetFees = hourlyBudgetFees;
    }

    public List<Double> getHourlyBudgetCounts() {
        return hourlyBudgetCounts;
    }

    public void setHourlyBudgetCounts(List<Double> hourlyBudgetCounts) {
        this.hourlyBudgetCounts = hourlyBudgetCounts;
    }

    public Long getPackageBudget() {
        return packageBudget;
    }

    public void setPackageBudget(Long packageBudget) {
        this.packageBudget = packageBudget;
    }

    public Double getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public String getIndustryTag() {
        return industryTag;
    }

    public void setIndustryTag(String industryTag) {
        this.industryTag = industryTag;
    }

    public String getIndustryTagNew() {
        return industryTagNew;
    }

    public void setIndustryTagNew(String industryTagNew) {
        this.industryTagNew = industryTagNew;
    }

    public Long getConvertTypeCost() {
        return convertTypeCost;
    }

    public void setConvertTypeCost(Long convertTypeCost) {
        this.convertTypeCost = convertTypeCost;
    }

    public Long getConvertCost() {
        return Optional.ofNullable(convertTypeCost).orElse(convertCost);
    }

    public void setConvertCost(Long convertCost) {
        this.convertCost = convertCost;
    }

    public String getNewTradeTagNum() {
        return newTradeTagNum;
    }

    public void setNewTradeTagNum(String newTradeTagNum) {
        this.newTradeTagNum = newTradeTagNum;
    }

    public Integer getCanReplaceLowArpu() {
        return canReplaceLowArpu;
    }

    public void setCanReplaceLowArpu(Integer canReplaceLowArpu) {
        this.canReplaceLowArpu = canReplaceLowArpu;
    }

    // 是否开启预算平滑,默认0. 1-表示开启
    public Integer getBudgetSmooth() {
        return Optional.ofNullable(budgetSmooth).orElse(0);
    }

    public void setBudgetSmooth(Integer budgetSmooth) {
        this.budgetSmooth = budgetSmooth;
    }

    public Boolean getEnabledExplore() {
        return enabledExplore;
    }

    public void setEnabledExplore(Boolean enabledExplore) {
        this.enabledExplore = enabledExplore;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdvertNewDto that = (AdvertNewDto) o;
        return Objects.equals(advertId, that.advertId) &&
                Objects.equals(this.packageId, that.packageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(advertId, packageId);
    }


    public static final class Builder {
        private Long advertId;
        private Long packageId;
        private Long fee;
        private Long launchCountToUser;
        private Integer chargeType;
        private Set<String> spreadTags;
        private String accountId;
        private String matchTagNums;
        private Set<MaterialDto> materials;
        private Map<Long, Set<String>> materialMapNew;
        private Double weight;
        private List<Double> hourlyBudgetFees;
        private List<Double> hourlyBudgetCounts;
        private Long packageBudget;
        private Double discountRate;
        private String industryTag;
        private String industryTagNew;
        private Long convertCost;
        private Long convertTypeCost;
        private Set<Long> backupAdvertIds;
        private Boolean supportStatus;
        private Boolean needSupportWeight;
        private Long assessCost;
        private Integer packageType;
        private Integer targetAppLimit;
        private Integer cvrType;
        private Boolean strongTarget;
        private String newTradeTagNum;
        private Integer budgetSmooth;
        private Integer depthCvrType;
        private Integer potentionalStatus;
        private Integer needPotentionalSupport;
        private Boolean floorPriceWhilteAdvert;

        private Builder() {
        }

        public Builder advertId(Long val) {
            advertId = val;
            return this;
        }

        public Builder packageId(Long val) {
            packageId = val;
            return this;
        }

        public Builder fee(Long val) {
            fee = val;
            return this;
        }

        public Builder launchCountToUser(Long val) {
            launchCountToUser = val;
            return this;
        }

        public Builder chargeType(Integer val) {
            chargeType = val;
            return this;
        }

        public Builder spreadTags(Set<String> val) {
            spreadTags = val;
            return this;
        }

        public Builder accountId(String val) {
            accountId = val;
            return this;
        }

        public Builder matchTagNums(String val) {
            matchTagNums = val;
            return this;
        }

        public Builder materials(Set<MaterialDto> val) {
            materials = val;
            return this;
        }

        public Builder materialMapNew(Map<Long, Set<String>> val) {
            materialMapNew = val;
            return this;
        }

        public Builder weight(Double val) {
            weight = val;
            return this;
        }

        public Builder hourlyBudgetFees(List<Double> val) {
            hourlyBudgetFees = val;
            return this;
        }

        public Builder hourlyBudgetCounts(List<Double> val) {
            hourlyBudgetCounts = val;
            return this;
        }

        public Builder packageBudget(Long val) {
            packageBudget = val;
            return this;
        }

        public Builder discountRate(Double val) {
            discountRate = val;
            return this;
        }

        public Builder industryTag(String val) {
            industryTag = val;
            return this;
        }

        public Builder industryTagNew(String val) {
            industryTagNew = val;
            return this;
        }

        public Builder convertCost(Long val) {
            convertCost = val;
            return this;
        }

        public Builder convertTypeCost(Long val) {
            convertTypeCost = val;
            return this;
        }

        public Builder backupAdvertIds(Set<Long> val) {
            backupAdvertIds = val;
            return this;
        }

        public Builder supportStatus(Boolean val) {
            supportStatus = val;
            return this;
        }

        public Builder needSupportWeight(Boolean val) {
            needSupportWeight = val;
            return this;
        }

        public Builder assessCost(Long val) {
            assessCost = val;
            return this;
        }

        public Builder packageType(Integer val) {
            packageType = val;
            return this;
        }

        public Builder targetAppLimit(Integer val) {
            targetAppLimit = val;
            return this;
        }

        public Builder cvrType(Integer val) {
            cvrType = val;
            return this;
        }

        public Builder depthCvrType(Integer val) {
            depthCvrType = val;
            return this;
        }

        public Builder strongTarget(Boolean val) {
            strongTarget = val;
            return this;
        }

        public Builder newTradeTagNum(String val) {
            newTradeTagNum = val;
            return this;
        }

        public Builder budgetSmooth(Integer val) {
            budgetSmooth = val;
            return this;
        }

        public Builder potentionalStatus(Integer val) {
            potentionalStatus = val;
            return this;
        }

        public Builder needPotentionalSupport(Integer val) {
            needPotentionalSupport = val;
            return this;
        }
        public Builder floorPriceWhilteAdvert(Boolean val) {
            floorPriceWhilteAdvert = val;
            return this;
        }

        public AdvertNewDto build() {
            return new AdvertNewDto(this);
        }

    }
}