package cn.com.duiba.nezha.engine.api.enums;

/**
 * 算法用的一个全局算法配置数据，根据这个获取缓存key
 */
public enum  CPCParamsKeyEnum {

    //用于CPC自动竞价
    CPC_AUTO_BIDING("cpcautobidding_params"),

    //用于CPC低质量标签
    CPC_NEG_TAG("cpcnegtag_params"),

    // 用于ocpc广告位优选
    OCPC_SLOT_PREFER("slotprefer_params"),

    // 用于ocpc维稳控制参数
    OCPC_BID_CONTROL("nz_alg_s_m_strategy_stat_model_v001"),

    // 广告优选融合阈值
    MERGE_THRESHOLD("nz_merge_threshold"),

    //广告位修正负采样
    HYPERPARAMS_NCW("hyperParams_ncw"),

    EXPLORE_PARAMS("explore_params"),

    ;
    private String keyType;

    CPCParamsKeyEnum(String keyType) {
        this.keyType = keyType;
    }


    public String getKeyType() {
        return keyType;
    }
}
