package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 大禹实验结果
 */
public enum DayuArgumentsEnum {


    // ocpc探索实验的key
    NAME("name", "ocpc_name"),

    PEOPLE_PREFER("peoplePrffer", "是否开启人群优选定向"),
    //EXPAND_NAME("expandname", "expandname"),

    PEOPLE_MODEL("peopleModel", "人群定向模型ID"),
    MERGE_MODEL("mergeModel", "广告位定向模型ID"),

    //StabilityABtestEnum
    STABILITY_AB("stability_ab", "维稳AB实验"),

    SUPPORT_AB("support_ab", "扶持AB实验"),
    ;

    // 开启
    public static final String OPEN = "1";
    // 关闭
    public static final String CLOSE = "0";

    // 定向实验组
    public static final String OCPC_EXP = "exp";
    public static final String OCPC_EXPA = "expA";
    public static final String OCPC_EXPB = "expB";
    public static final String OCPC_EXPC = "expC";
    // 定向大盘组
    public static final String OCPC_MAIN = "main";

    // 维稳双出价实验 2
    public static final String STABILITY_B = "2";


    private String key;

    private String desc;


    DayuArgumentsEnum(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static DayuArgumentsEnum get(String key) {

        for (DayuArgumentsEnum dayuArgumentsEnum : DayuArgumentsEnum.values()) {
            if (dayuArgumentsEnum.getKey().equals(key)) {
                return dayuArgumentsEnum;
            }
        }
        return null;
    }

    public String getKey() {

        return key;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 判断是否关闭，true-关闭，false-未关闭
     * @param argumetValue 实验参数值
     * @return
     */
    public static boolean judgeClose(String argumetValue){

        return CLOSE.equals(argumetValue);
    }

    /**
     * 判断是否关闭，true-开启，false-未开启
     * @param argumetValue 实验参数值
     * @return
     */
    public static boolean judgeOpen(String argumetValue){
        return OPEN.equals(argumetValue);
    }


    /**
     * 不同的实验组对应不同的redisKey
     * <href a="http://cf.dui88.com/pages/viewpage.action?pageId=93042475">探索调价方案</href>
     */
    @Getter
    @AllArgsConstructor
    public enum ExploreV2Enum {
        expA(OCPC_EXPA, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPA_1, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPA_2),
        expB(OCPC_EXPB, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPB_1, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPB_2),
        expC(OCPC_EXPC, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPC_1, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPC_2);

        private final String expName;
        private final CPCParamsKeyEnum redis1;
        private final CPCParamsKeyEnum redis2;

        private static final Map<String, ExploreV2Enum> map = Arrays.stream(ExploreV2Enum.values())
                .collect(Collectors.toMap(ExploreV2Enum::getExpName, v -> v));

        public static ExploreV2Enum of(String expName) {
            return map.get(expName);
        }
    }
}
