package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 策略类型
 */
public enum InteractAdvertAlgEnum implements AdvertAlgEnum {


    BTM_AND_PC_39(239, "ADX预发模型"),


    BTM_AND_PC_65(265, "new_trade"),

    BTM_AND_PC_74(274, "dcn2素材"),
    BTM_AND_PC_75(275, "deep_fm2素材"),
    BTM_AND_PC_77(277, "xdeepfm5素材"),
    BTM_AND_PC_78(278, "素材改造-在线版"),
    BTM_AND_PC_79(279, "素材改造-在线版-对照组"),

    BTM_AND_PC_91(291, "dmp特征-在线版-291"),
    BTM_AND_PC_92(292, "dmp特征-在线版-292"),

    // 297，298adx-nezha那边已经用了

    BTM_AND_PC_3_10(310, "sample_v002深度模型tf server"),
    BTM_AND_PC_3_11(311, "sample_v002深度模型tf local"),
    BTM_AND_PC_3_12(312, "sample_v002大盘组"),

    BTM_AND_PC_3_15(315, "美团FM016"),
    BTM_AND_PC_3_16(316, "美团FM017"),

    BTM_AND_PC_3_17(317, "美团FM018"),
    BTM_AND_PC_3_18(318, "美团FM019"),


    BTM_AND_PC_3_22(322, "美团FM010"),


    BTM_AND_PC_3_25(325, "爱奇艺v016_v010"),
    BTM_AND_PC_3_26(326, "爱奇艺v010_v010"),
    BTM_AND_PC_3_27(327, "爱奇艺v010_v010"),
    BTM_AND_PC_3_24(324, "爱奇艺v010_v005"),

    BTM_AND_PC_3_28(328, "CAN_对照组"),
    BTM_AND_PC_3_29(329, "CAN_实验组"),

    BTM_AND_PC_3_31(331, "美团316实验组"),

    BTM_AND_PC_3_32(332, "美团316对照组"),

    BTM_AND_PC_3_33(333, "爱奇艺v010_v008"),

    BTM_AND_PC_3_34(334, "爱奇艺v010_v009"),

    BTM_AND_PC_3_35(335, "FM403"),
    BTM_AND_PC_3_36(336, "FM404"),


    ;


    private Integer type;

    private String desc;

    private static final Map<String, InteractAdvertAlgEnum> CACHE = Arrays.stream(InteractAdvertAlgEnum.values())
            .collect(HashMap::new,(m,v)->m.put(v.getType().toString(),v),HashMap::putAll);


    InteractAdvertAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AdvertAlgEnum get(String strategyId) {
        return CACHE.get(strategyId);
    }


    @Override
    public Integer getType() {

        return type;
    }

    public String getDesc() {
        return desc;
    }


}
