/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.api.enums;

import cn.com.duiba.nezha.engine.api.enums.CPCParamsKeyEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DayuArgumentsEnum {
    NAME("name", "ocpc_name"),
    PEOPLE_PREFER("peoplePrffer", "\u662f\u5426\u5f00\u542f\u4eba\u7fa4\u4f18\u9009\u5b9a\u5411"),
    PEOPLE_MODEL("peopleModel", "\u4eba\u7fa4\u5b9a\u5411\u6a21\u578bID"),
    MERGE_MODEL("mergeModel", "\u5e7f\u544a\u4f4d\u5b9a\u5411\u6a21\u578bID"),
    STABILITY_AB("stability_ab", "\u53cc\u51fa\u4ef7AB\u5b9e\u9a8c"),
    SUPPORT_AB("support_ab", "\u6276\u6301AB\u5b9e\u9a8c"),
    FAST_AB("fast_ab", "\u8dd1\u91cfAB\u5b9e\u9a8c"),
    NEWO_AB("newO_ab", "\u65b0O ab\u5b9e\u9a8c"),
    CLOUD_BOOT_AB("cloudBoot_ab", "\u51b7\u542f\u52a8AB\u5b9e\u9a8c");

    public static final String OPEN = "1";
    public static final String CLOSE = "0";
    public static final String OCPC_EXP = "exp";
    public static final String OCPC_EXPA = "expA";
    public static final String OCPC_EXPB = "expB";
    public static final String OCPC_EXPC = "expC";
    public static final String OCPC_MAIN = "main";
    public static final String ab_exp = "2";
    private String key;
    private String desc;

    private DayuArgumentsEnum(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public static DayuArgumentsEnum get(String key) {
        for (DayuArgumentsEnum dayuArgumentsEnum : DayuArgumentsEnum.values()) {
            if (!dayuArgumentsEnum.getKey().equals(key)) continue;
            return dayuArgumentsEnum;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean judgeClose(String argumetValue) {
        return CLOSE.equals(argumetValue);
    }

    public static boolean judgeOpen(String argumetValue) {
        return OPEN.equals(argumetValue);
    }

    public static enum ExploreV2Enum {
        expA("expA", CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPA_1, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPA_2),
        expB("expB", CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPB_1, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPB_2),
        expC("expC", CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPC_1, CPCParamsKeyEnum.EXPLORE_ALG_APP_AD_EXPC_2);

        private final String expName;
        private final CPCParamsKeyEnum redis1;
        private final CPCParamsKeyEnum redis2;
        private static final Map<String, ExploreV2Enum> map;

        public static ExploreV2Enum of(String expName) {
            return map.get(expName);
        }

        public String getExpName() {
            return this.expName;
        }

        public CPCParamsKeyEnum getRedis1() {
            return this.redis1;
        }

        public CPCParamsKeyEnum getRedis2() {
            return this.redis2;
        }

        private ExploreV2Enum(String expName, CPCParamsKeyEnum redis1, CPCParamsKeyEnum redis2) {
            this.expName = expName;
            this.redis1 = redis1;
            this.redis2 = redis2;
        }

        static {
            map = Arrays.stream(ExploreV2Enum.values()).collect(Collectors.toMap(ExploreV2Enum::getExpName, v -> v));
        }
    }
}

