package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 策略类型
 */
public enum DoubleFeeAlgEnum {

    //取模型
    DOUBLE_MODEL_1(201, "双出价模型v001"),
    DOUBLE_MODEL_4(204, "双出价模型v004"),
    DOUBLE_MODEL_5(205, "双出价模型v005"),
    DOUBLE_MODEL_6(206, "双出价模型v006"),
    DOUBLE_MODEL_7(207, "双出价模型v007 esmm"),
    DOUBLE_MODEL_8(208, "双出价模型v008 deepfm"),
    DOUBLE_MODEL_9(209, "双出价模型v007 esmm//本地化读取模型test"),
    DOUBLE_MODEL_10(210, "双出价模型v010 dcn"),

    ;


    private Integer type;

    private String desc;

    private static final Map<String, DoubleFeeAlgEnum> CACHE = Arrays.stream(DoubleFeeAlgEnum.values())
            .collect(HashMap::new,(m,v)->m.put(v.getType().toString(),v),HashMap::putAll);


    DoubleFeeAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static DoubleFeeAlgEnum get(String strategyId) {
        return CACHE.get(strategyId);
    }

    public Integer getType() {

        return type;
    }

    public String getDesc() {
        return desc;
    }


}
