package cn.com.duiba.nezha.engine.api.dto;

import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 请求参数
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RequestDto.java , v 0.1 2017/6/8 下午6:54 ZhouFeng Exp $
 */
@Getter
@Setter
public class RequestDto implements Serializable {
    private static final long serialVersionUID = 5050061063037262986L;

    /**
     * 点击按钮的客户端的UA
     */
    private String ua;

    /**
     * ip
     */
    private String ip;

    /**
     * 城市id
     */
    private Long cityId;

    /**
     * 订单id
     */
    private String orderId;
    /**
     * 设备价格区间
     */
    private String priceSection;

    /**
     * 发券次序，该用户当日发券次数
     */
    private Long putIndex;

    /**
     * 机型
     */
    private String model;

    /**
     * 网络类型（2G，3G，4G）
     */
    private String connectionType;

    /**
     * 运营商（中国联通，中国移动，中国电信）
     */
    private String operatorType;

    /**
     * 手机品牌
     */
    private String phoneBrand;

    /**
     * 手机型号
     */
    private String phoneModel;

    /**
     * 订单列表
     */
    private List<String> orderIds;

    /**
     * 需要的广告数
     */
    private Long needCount;

    /**
     * 已存在广告数
     */
    private Long existCount;

    /**
     * 低arpu值券阈值（下线了，需通知engine）
     */
    private Double lowArpuThresholdValue;

    /**
     * 判断是否是ADX预发券.1-是预发发券,2是真实发券
     */
    private Integer adxLoadType;

    /**
     * 增值广告请求时的订单id（下线了，需通知engine）
     */
    private String encourageOrderId;

    /**
     * 低价白名单是否开启 true -开启 false 关闭
     */
    private Boolean floorPriceWhiteListOff;

    /**
     * 广告后台底价
     * @return
     */
    private Long floorPrice;

    /**
     * 1,"年龄特征" 0 学生 1非学生 null未知
     *
     */
    private Integer workState;
    /**
     *  * 2,"性别特征" 0 -女 1 男 null 未知
     */
    private Integer sex;

    /**
     * 流量类型
     * @FlowTypeEnum
     */
    private Integer flowType;

    /**
     * 双出价第二层实验-model
     */
    private String sceneDoubleFeeModel;

    /**
     * 算法需要的各类特征
     */
    private Map<String, String> algFeatureMap;

    /**
     * 分流实验map
     */
    private Map<String, String> dayuArgumentsMap;

    /**
     * 设备编号
     */
    private String phoneModelCode;

    /**
     * 品牌英文名字
     */
    private String brandNameEn;

    /**
     * 设备价值
     */
    private String phonePriceLevel;

    /**
     * 首发年份
     */
    private Integer firstShowTime;

    /**
     * 运营商标签
     */
    private Integer dmplspCustom;

    /**
     * 操作系统
     */
    private String phoneOs;

    public Long getFloorPrice() {
        return Optional.ofNullable(floorPrice).orElse(0L);
    }


    public Boolean getFloorPriceWhiteListOff() {
        return Optional.ofNullable(floorPriceWhiteListOff).orElse(Boolean.TRUE);
    }

    public Long getExistCount() {
        return Optional.ofNullable(existCount).orElse(0L);
    }


    public List<String> getOrderIds() {
        return Optional.ofNullable(orderIds).orElse(Lists.newArrayList(orderId));
    }


    public Long getNeedCount() {
        return Optional.ofNullable(needCount).orElse(1L);
    }

}
