package cn.com.duiba.nezha.engine.api.enums;

import java.text.MessageFormat;

/**
 * @author lijicong
 * @since 2020-12-02
 */
public interface CacheKeyEnumerable {

    String SEPARATOR = "_";

    String getKey();
    String getFormat();

    default String getSpace() {
        return "NZ";
    }

    default String getSeparator() {
        return SEPARATOR;
    }

    default String generateKey(Object... keySuffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(getSpace()).append(getSeparator()).append(getKey());
        if (keySuffix != null) {
            for (Object temp : keySuffix) {
                sb.append(getSeparator());
                sb.append(temp);
            }
        }
        return sb.toString();
    }

    default String formatKey(Object... keySuffix) {
       return MessageFormat.format(getSpace() + getSeparator() + getFormat(), keySuffix);
    }
}
