package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 策略类型
 */
public enum InteractAdvertAlgEnum implements AdvertAlgEnum {


    BTM_AND_PC_39(239, "ADX预发模型"),


    BTM_AND_PC_65(265, "new_trade"),

    BTM_AND_PC_74(274, "dcn2素材"),
    BTM_AND_PC_75(275, "deep_fm2素材"),
    BTM_AND_PC_77(277, "xdeepfm5素材"),
    BTM_AND_PC_78(278, "素材改造-在线版"),
    BTM_AND_PC_79(279, "素材改造-在线版-对照组"),
    BTM_AND_PC_80(280, "素材改造-在线版"),

    BTM_AND_PC_91(291, "dmp特征-在线版-291"),
    BTM_AND_PC_92(292, "dmp特征-在线版-292"),

    // 297，298adx-nezha那边已经用了

    BTM_AND_PC_3_10(310, "sample_v002深度模型tf server"),
    BTM_AND_PC_3_11(311, "sample_v002深度模型tf local"),
    BTM_AND_PC_3_12(312, "sample_v002大盘组"),

    BTM_AND_PC_3_15(315, "美团FM016"),
    BTM_AND_PC_3_16(316, "美团FM017"),

    BTM_AND_PC_3_17(317, "美团FM018"),
    BTM_AND_PC_3_18(318, "美团FM019"),


    BTM_AND_PC_3_22(322, "美团FM010"),


    BTM_AND_PC_3_25(325, "爱奇艺v016_v010"),
    BTM_AND_PC_3_26(326, "爱奇艺v010_v010"),
    BTM_AND_PC_3_27(327, "爱奇艺v010_v010"),
    BTM_AND_PC_3_24(324, "爱奇艺v010_v005"),

    BTM_AND_PC_3_28(328, "CAN_对照组"),
    BTM_AND_PC_3_29(329, "CAN_实验组"),

    BTM_AND_PC_3_31(331, "美团316实验组"),

    BTM_AND_PC_3_32(332, "美团316对照组"),

    BTM_AND_PC_3_33(333, "爱奇艺v010_v008"),

    BTM_AND_PC_3_34(334, "爱奇艺v010_v009"),

    BTM_AND_PC_3_35(335, "FM403"),
    BTM_AND_PC_3_36(336, "FM404"),

    BTM_AND_PC_3_37(337, "FM405"),
    BTM_AND_PC_3_38(338, "FM406"),
    BTM_AND_PC_3_39(339, "FM407"),
    BTM_AND_PC_3_40(340, "FM408"),

    BTM_AND_PC_3_41(341, "爱奇艺v010_v010"),

    BTM_AND_PC_3_42(342, "FM409"),
    BTM_AND_PC_3_43(343, "FM410"),

    BTM_AND_PC_3_44(344, "美团大盘_017"),
    BTM_AND_PC_3_45(345, "美团大盘_011"),
    BTM_AND_PC_3_46(346, "美团大盘_012"),

    BTM_AND_PC_3_47(347, "本地模型403"),
    BTM_AND_PC_3_48(348, "本地模型412"),

    BTM_AND_PC_3_49(349, "本地模型413"),
    BTM_AND_PC_3_50(350, "本地模型414"),
    BTM_AND_PC_3_51(351, "本地模型415"),
    BTM_AND_PC_3_52(352, "本地模型416"),

    BTM_AND_PC_3_53(353, "本地模型417"),
    BTM_AND_PC_3_54(354, "本地模型418"),

    BTM_AND_PC_3_55(355, "本地模型419"),
    BTM_AND_PC_3_56(356, "本地模型420"),
    BTM_AND_PC_3_57(357, "本地模型421"),
    BTM_AND_PC_3_58(358, "本地模型422"),

    BTM_AND_PC_3_59(359, "本地模型423"),
    BTM_AND_PC_3_60(360, "本地模型424"),

    BTM_AND_PC_3_61(361, "本地模型426"),
    BTM_AND_PC_3_62(362, "本地模型427"),
    BTM_AND_PC_3_63(363, "本地模型428"),
    BTM_AND_PC_3_64(364, "本地模型429"),
    BTM_AND_PC_3_65(365, "本地模型416"),

    BTM_AND_PC_3_66(366, "oneID模型测试430"),
    BTM_AND_PC_3_67(367, "oneID模型测试431"),

    BTM_AND_PC_3_68(368, "性别标签分流"),

    BTM_AND_PC_3_69(369, "年龄新模型"),
    BTM_AND_PC_3_70(370, "年龄新模型"),
    BTM_AND_PC_3_71(371, "远程模型FM"),

    BTM_AND_PC_3_72(372, "oneID模型测试437"),
    BTM_AND_PC_3_73(373, "oneID模型测试438"),
    BTM_AND_PC_3_74(374, "oneID模型测试439"),
    BTM_AND_PC_3_75(375, "oneID模型测试440"),

    BTM_AND_PC_3_76(376, "模型测试440"),
    BTM_AND_PC_3_77(377, "模型测试441"),
    BTM_AND_PC_3_78(378, "模型测试442"),
    BTM_AND_PC_3_79(379, "模型测试443"),
    BTM_AND_PC_3_80(380, "新增UA特征CVR预估策略380"),
    BTM_AND_PC_3_81(381, "新增UA特征CVR预估策略381"),
    BTM_AND_PC_3_82(382, "新增UA特征CVR预估策略382"),
    BTM_AND_PC_3_83(383, "新增UA特征CVR预估策略383"),


    ;


    private Integer type;

    private String desc;

    private static final Map<String, InteractAdvertAlgEnum> CACHE = Arrays.stream(InteractAdvertAlgEnum.values())
            .collect(HashMap::new,(m,v)->m.put(v.getType().toString(),v),HashMap::putAll);


    InteractAdvertAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AdvertAlgEnum get(String strategyId) {
        return CACHE.get(strategyId);
    }


    @Override
    public Integer getType() {

        return type;
    }

    public String getDesc() {
        return desc;
    }


}
