package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 活动定制场景
 * @author lijicong
 * @since 2021-07-13
 */
@Getter
@AllArgsConstructor
public enum ActivitySceneEnum {

    ACTIVITY_CUSTOMIZED_ADVERT(1, "活动定制广告"),
    STRONG_COUPONS(2, "强发券"),
    ;

    private final Integer code;
    private final String desc;

    private static final Map<Integer, ActivitySceneEnum> map = Arrays.stream(ActivitySceneEnum.values())
            .collect(Collectors.toMap(ActivitySceneEnum::getCode, v -> v));

    public ActivitySceneEnum of(Integer code) {
        return map.get(code);
    }

    public boolean is(Integer code) {
        return this.code.equals(code);
    }


}
