package cn.com.duiba.nezha.engine.api.dto;

import cn.com.duiba.nezha.engine.api.enums.AppEnums.TestTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Optional;

/**
 * app参数
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AppDto.java , v 0.1 2017/6/8 下午6:55 ZhouFeng Exp $
 */
@Setter
@Getter
public class AppDto implements Serializable {
    private static final long serialVersionUID = -6117135769384442700L;

    private Long appId;

    /**
     * app类型
     */
    private String appCategory;

    /** app测试类型 0-老媒体 1-新媒体 {@link TestTypeEnum} */
    private Integer appTestType;

    /**
     * 广告位id
     */
    private Long slotId;

    /**
     * 广告位宽度
     */
    private Integer slotWidth;

    /**
     * 广告位高度
     */
    private Integer slotHeight;

    /**
     * 广告位类型 0-插屏 1-横幅 2-信息流 3-banner 4-浮标 5-应用墙.
     */
    private Integer slotType;

    /**
     * 投放场景 1:'插屏',2:'banner/横幅',3:'信息流',6:'浮标',7:'应用墙',8:'开屏',9:'自定义场景',10:'原生插屏'
     */
    private Integer sceneType;

    /**
     * 媒体类型，0非美团，1-美团
     */
    private Integer adxMediaType;

    /**
     * 活动场景类型 see cn.com.tuia.advert.enums.AdxSceneEnum
     */
    private String  adxSceneType;

    /**
     * 广告位标签父ID
     */
    private String slotIndustryTagPid;

    /**
     * 广告位标签ID
     */
    private String slotIndustryTagId;

    /**
     * 媒体标签父ID
     */
    private String appIndustryTagPid;

    /**
     * 媒体标签ID
     */
    private String appIndustryTagId;

    /**
     * 流量标签ID
     */
    private String trafficTagId;

    /**
     * 流量标签父ID
     */
    private String trafficTagPid;

    /**
     * 流量dmp人群标签
     */
    private String appUserInterest;

    /**
     * 流量基础标签
     * @return
     */
    private String imeiBasicTags;

    /**
     * 美团用的，1-表示5张rankScore最高的券， 2-表示5个行业最高rankScore的券
     */
    private Integer adVirtue;

    /**
     * 爱奇艺性别标签
     */
    @Deprecated
    private String aqySex;
    /**
     * 爱奇艺年龄标签
     */
    @Deprecated
    private String aqyAge;
    /**
     * 媒体是否网赚标签
     */
    private Long appEmoBlockTagId;
    /**
     * 广告位接入方式标签ID
     */
    private Long slotAccessTagId;
    /** 媒体交易方式 */
    private Long appTradeTypeTagId;
    /** 媒体流量载体 */
    private Long appCarrierFlowTagId;

    public Integer getAdxMediaType() {
        return Optional.ofNullable(adxMediaType).orElse(0);
    }


}
