package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lijicong
 * @since 2021-10-29
 */
public class AdxEnums {

    //加密"null"字符串的deviceId
    public static final String DEVICEID_NULL = "37a6259cc0c1dae299a7866489dff0bd";

    @Getter
    @AllArgsConstructor
    public enum AdxMediaType {
        MEITUAN(1, "美团"),
        OTHER(0, "非美团"),
        ;

        private final Integer type;
        private final String desc;

        public boolean is(Integer type) {
            return this.type.equals(type);
        }
    }

    // adx预发券标识,1-是预发券,2-是真实发券
    @Getter
    @AllArgsConstructor
    public enum AdxLoadType {
        PRE(1, "预发券"),
        REAL(2, "真实发券");

        private final Integer type;
        private final String desc;

        public boolean is(Integer type) {
            return this.type.equals(type);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum AppIdEnum {
        MEITUAN(67018L, "美团"),
        ;
        private final Long id;
        private final String desc;
        public boolean is(Long id) {
            return this.id.equals(id);
        }
    }

}
