package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 超阈值类型枚举
 *
 * @author zhangbaiqiang
 * @date 2021/6/23
 */
@Getter
@AllArgsConstructor
public enum ExceedType {

    NOT_EXCEED(0, "未超阈值"),
    CONSUME_EXCEED(1, "配置消耗超阈值"),
    EXPOSURE_EXCEED(2, "配置曝光超阈值")
    ;

    private final Integer type;
    private final String desc;

    /**
     * 判断是否未超阈值
     *
     * @param exceedType 超阈值类型
     * @return 是否未超阈值
     */
    public static boolean isNotExceed(Integer exceedType) {
        return Objects.equals(NOT_EXCEED.getType(), exceedType);
    }
}
