/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2019/4/26.
 **/
package cn.com.duiba.nezha.engine.api.dto;

import java.io.Serializable;
import java.util.Set;

/**
 * 托管自救参数
 * @Author kongbo kongbo@duiba.comc.cn
 */
public class RescureDto implements Serializable {


    private static final long serialVersionUID = -4602138342704462271L;
    /**
     * 消耗异常指数
     */
    private Double costException;

    /**
     * 成本异常指数
     */
    private Double costConvertException;

    /**
     *严重异常
     */

    private  Double fatalException;

    /**
     * 1:系统精准自救 2：系统尝试自救 3：提示人工自救
     */
    private Set<Integer> helpBySelfType;

    /**
     * 托管是否拓量
     */
    private Boolean isExpand;

    /**
     * 拓量无历史数据定向率加权因子
     */
    private Double orientRatioWeight;

    /**
     * 拓量-未定向重新定向
     */
    private Double isReorient;

    /**
     * 拓量-黑名单
     */
    private Double isBlackRealse;

    /**
     * 重置维稳因子
     **/
    private Boolean isResetStableFactor;


    /**
     * 提示AE人工自救
     */
    private Set<Integer> remindAE;

    public Double getCostException() {
        return costException;
    }

    public void setCostException(Double costException) {
        this.costException = costException;
    }

    public Double getCostConvertException() {
        return costConvertException;
    }

    public void setCostConvertException(Double costConvertException) {
        this.costConvertException = costConvertException;
    }

    public Double getFatalException() {
        return fatalException;
    }

    public void setFatalException(Double fatalException) {
        this.fatalException = fatalException;
    }

    public Set<Integer> getHelpBySelfType() {
        return helpBySelfType;
    }

    public void setHelpBySelfType(Set<Integer> helpBySelfType) {
        this.helpBySelfType = helpBySelfType;
    }

    public Boolean getExpand() {
        return isExpand;
    }

    public void setExpand(Boolean expand) {
        isExpand = expand;
    }

    public Double getOrientRatioWeight() {
        return orientRatioWeight;
    }

    public void setOrientRatioWeight(Double orientRatioWeight) {
        this.orientRatioWeight = orientRatioWeight;
    }

    public Double getIsReorient() {
        return isReorient;
    }

    public void setIsReorient(Double isReorient) {
        this.isReorient = isReorient;
    }

    public Double getIsBlackRealse() {
        return isBlackRealse;
    }

    public void setIsBlackRealse(Double isBlackRealse) {
        this.isBlackRealse = isBlackRealse;
    }

    public Boolean getResetStableFactor() {
        return isResetStableFactor;
    }

    public void setResetStableFactor(Boolean resetStableFactor) {
        isResetStableFactor = resetStableFactor;
    }

    public Set<Integer> getRemindAE() {
        return remindAE;
    }

    public void setRemindAE(Set<Integer> remindAE) {
        this.remindAE = remindAE;
    }

}

