package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lijicong
 * @since 2021-09-09
 */
@Getter
@AllArgsConstructor
public enum RedisKeyNezha implements CacheKeyEnumerable {

    A1("A1", "A1_{0}_advert_{1}_{2}", "热度召回"),  // {0}指标维度-{1}时间维度-{3}广告位
    A2("A2", "A2_{0}_advert_{1}_{2}", "广告行业泛化召回"),
    A3("A3", "A3", "随机召回"),
    A4("A4", "A4_{0}_app_{1}_{2}", "媒体行业泛化召回"),
    A12("A12", "A12_{0}_cf_{1}", "协同过滤"),

    ;

    private final String key;
    private final String format;
    private final String desc;

}
