package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum AdvertType {

    SHOW(2, "展示广告", 4),

    INTERACT(1, "互动广告", -1),
    ;
    private Integer value;
    private String desc;
    private Integer mainType;

    private static final Map<Integer, AdvertType> map = Arrays.stream(AdvertType.values())
            .collect(Collectors.toMap(AdvertType::getValue, v -> v));

    public static AdvertType of(Integer code) {
        return map.getOrDefault(code, AdvertType.INTERACT);
    }

    AdvertType(Integer value, String desc, Integer mainType) {
        this.value = value;
        this.desc = desc;
        this.mainType = mainType;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getMainType(){
        return mainType;
    }
}
