package cn.com.duiba.nezha.engine.biz.domain.advert;

import cn.com.duiba.nezha.engine.api.dto.AdvertNewDto;
import cn.com.duiba.nezha.engine.biz.constant.GlobalConstant;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.enums.AdvertType;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Advert implements StatisticDataGetter {

    // 广告id
    private Long id;
    // 广告类型
    private AdvertType type;
    private Long accountId;
    // 推广标签
    private Set<String> spreadTags;
    // 定向配置包
    private Set<OrientationPackage> orientationPackages;
    // 已经对用户发的次数
    private Long launchCountToUser;
    // 权重
    private Double weight;
    // 行业标签
    private String industryTag;
    // 备用广告列表
    private Set<Long> backupAdvertIds;
    // 属性标签
    private String matchTags;
    // 折扣率
    private Double discountRate;
    //资源标签
    private String resourceTagNum;
    // 媒体融合数据
    private MergeData appMergeData;
    // 全局融合数据
    private MergeData globalMergeData;
    //活动引擎是否需要低arpu值券:1.需要 0.不需要
    private Integer canReplaceLowArpu;

    private StatisticData hourStatisticData;
    private StatisticData todayStatisticData;
    private StatisticData recently7DayStatisticData;
    private StatisticData hourAppStatisticData;
    private StatisticData todayAppStatisticData;
    private StatisticData recently7DayAppStatisticData;



//    private Double statCtr;
//    private Double statCvr;

    public static Advert convert(AdvertNewDto advertDto, AdvertType advertType) {
        Advert newAdvert = new Advert();
        newAdvert.setId(advertDto.getAdvertId());
        newAdvert.setType(advertType);
        newAdvert.setAccountId(Long.parseLong(advertDto.getAccountId()));
        newAdvert.setSpreadTags(advertDto.getSpreadTags());
        newAdvert.setLaunchCountToUser(advertDto.getLaunchCountToUser());
        newAdvert.setWeight(Optional.ofNullable(advertDto.getWeight()).orElse(GlobalConstant.DEFAULT_ADVERT_WEIGHT));
        newAdvert.setIndustryTag(advertDto.getIndustryTagNew());
        newAdvert.setBackupAdvertIds(advertDto.getBackupAdvertIds());
        newAdvert.setMatchTags(advertDto.getMatchTagNums());
        newAdvert.setDiscountRate(advertDto.getDiscountRate());
        newAdvert.setCanReplaceLowArpu(Optional.ofNullable(advertDto.getCanReplaceLowArpu()).orElse(0));
        newAdvert.setResourceTagNum(advertDto.getResourceTagNum());
        return newAdvert;
    }

    public String getResourceTagNum() {
        return resourceTagNum;
    }

    public void setResourceTagNum(String resourceTagNum) {
        this.resourceTagNum = resourceTagNum;
    }

    public StatisticData getHourAppStatisticData() {
        return hourAppStatisticData;
    }

    public void setHourAppStatisticData(StatisticData hourAppStatisticData) {
        this.hourAppStatisticData = hourAppStatisticData;
    }

    public StatisticData getTodayAppStatisticData() {
        return todayAppStatisticData;
    }

    public void setTodayAppStatisticData(StatisticData todayAppStatisticData) {
        this.todayAppStatisticData = todayAppStatisticData;
    }

    public StatisticData getRecently7DayAppStatisticData() {
        return recently7DayAppStatisticData;
    }

    public void setRecently7DayAppStatisticData(StatisticData recently7DayAppStatisticData) {
        this.recently7DayAppStatisticData = recently7DayAppStatisticData;
    }

    public AdvertType getType() {
        return type;
    }

    public void setType(AdvertType type) {
        this.type = type;
    }

    public StatisticData getHourStatisticData() {
        return hourStatisticData;
    }

    public void setHourStatisticData(StatisticData hourStatisticData) {
        this.hourStatisticData = hourStatisticData;
    }

    public StatisticData getTodayStatisticData() {
        return todayStatisticData;
    }

    public void setTodayStatisticData(StatisticData todayStatisticData) {
        this.todayStatisticData = todayStatisticData;
    }

    public StatisticData getRecently7DayStatisticData() {
        return recently7DayStatisticData;
    }

    public void setRecently7DayStatisticData(StatisticData recently7DayStatisticData) {
        this.recently7DayStatisticData = recently7DayStatisticData;
    }

//    public Double getStatCtr() {
//        return statCtr;
//    }
//
//    public void setStatCtr(Double statCtr) {
//        this.statCtr = statCtr;
//    }
//
//    public Double getStatCvr() {
//        return statCvr;
//    }
//
//    public void setStatCvr(Double statCvr) {
//        this.statCvr = statCvr;
//    }

    public Optional<MergeData> getAppMergeData() {
        return Optional.ofNullable(appMergeData);
    }

    public void setAppMergeData(MergeData appMergeData) {
        this.appMergeData = appMergeData;
    }

    public Optional<MergeData> getGlobalMergeData() {
        return Optional.ofNullable(globalMergeData);
    }

    public void setGlobalMergeData(MergeData globalMergeData) {
        this.globalMergeData = globalMergeData;
    }

    public Double getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public String getMatchTags() {
        return matchTags;
    }

    public void setMatchTags(String matchTags) {
        this.matchTags = matchTags;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Set<String> getSpreadTags() {
        return Optional.ofNullable(spreadTags).orElseGet(HashSet::new);
    }

    public void setSpreadTags(Set<String> spreadTags) {
        this.spreadTags = spreadTags;
    }

    public Set<OrientationPackage> getOrientationPackages() {
        return Optional.ofNullable(orientationPackages).orElseGet(HashSet::new);
    }

    public void setOrientationPackages(Set<OrientationPackage> orientationPackages) {
        this.orientationPackages = orientationPackages;
    }

    public Long getLaunchCountToUser() {
        return launchCountToUser;
    }

    public void setLaunchCountToUser(Long launchCountToUser) {
        this.launchCountToUser = launchCountToUser;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public String getIndustryTag() {
        return industryTag;
    }

    public void setIndustryTag(String industryTag) {
        this.industryTag = industryTag;
    }

    public Set<Long> getBackupAdvertIds() {
        return backupAdvertIds;
    }

    public void setBackupAdvertIds(Set<Long> backupAdvertIds) {
        this.backupAdvertIds = backupAdvertIds;
    }

    public Integer getCanReplaceLowArpu() { return canReplaceLowArpu; }

    public void setCanReplaceLowArpu(Integer canReplaceLowArpu) { this.canReplaceLowArpu = canReplaceLowArpu; }

    public Long getCurrentCount() {
        long currentCount = Optional.ofNullable(this.launchCountToUser).orElse(0L) + 1;
        if (currentCount > 10) {
            currentCount = 10;
        }
        return currentCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Advert advert = (Advert) o;
        return Objects.equals(id, advert.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public Boolean hasCvrData() {
        return orientationPackages.stream().anyMatch(OrientationPackage::isCpa)
                || (globalMergeData != null
                && globalMergeData.getExposureCount() != null
                && globalMergeData.getExposureCount() > 0);
    }


    public Boolean isNew() {
        return Optional.ofNullable(globalMergeData)
                .map(MergeData::getLaunchCount)
                .orElse(0L) <= GlobalConstant.NEW_ADD_AD_THRESHOLD;
    }
}
