package cn.com.duiba.nezha.engine.biz.enums;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static cn.com.duiba.nezha.engine.biz.constant.GlobalConstant.INTERACT_DEFAULT_CVR;

public enum BackendDefaultCVR {
    _0("0",INTERACT_DEFAULT_CVR),
    _1("1",0.01),
    _2("2",0.01),
    _3("3",0.01),
    _4("4",0.01),
    ;

    private String type;
    private Double cvr;

    public String getType() {
        return type;
    }

    public Double getCvr() {
        return cvr;
    }

    BackendDefaultCVR(String type, Double cvr) {
        this.type = type;
        this.cvr = cvr;
    }

    private final static Map<String, BackendDefaultCVR> CACHE = Stream.of(BackendDefaultCVR.values()).collect(Collectors.toMap(BackendDefaultCVR::getType, Function.identity()));

    public static Double getCvr(Integer type) {
        return CACHE.get(type.toString()).getCvr();
    }
}
