package cn.com.duiba.nezha.engine.biz.log;

import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.BizLogEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.RoiLogEntity;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;

public class BaseInnerLog {

    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInnerLog.class);

    /**
     * 广告平台日志统一分组
     */
    private static final String ADVERT_INNER_LOG_GROUP = "1";

    /**
     * 发券日志类型
     */
    private static final String ADVERT_INNER_LOG_RECOMMEND = "38";

    /**
     * 特征日志类型
     */
    private static final String ADVERT_INNER_LOG_FEATURE = "48";

    /**
     * 维稳日志
     */
    private static final String ADVERT_ROI_LOG = "120";


    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static void log(BizLogEntity bizLogEntity) {
        Optional.ofNullable(bizLogEntity).ifPresent(entry -> log(ADVERT_INNER_LOG_RECOMMEND, JSON.toJSONString(entry)));
    }
    public static void log(RoiLogEntity roiLogEntity) {
        Optional.ofNullable(roiLogEntity).ifPresent(entry -> log(ADVERT_ROI_LOG, JSON.toJSONString(entry)));
    }
    public static void log(Map<String, String> featureMap) {
        if (MapUtils.isNotEmpty(featureMap)) {
            log(ADVERT_INNER_LOG_FEATURE, JSON.toJSONString(featureMap));
        }
    }

    private static void log(String logType, String jsonLog) {
        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(ADVERT_INNER_LOG_GROUP);
        ruleDto.setJson(jsonLog);
        ruleDto.setTime(LocalDateTime.now().format(DATE_TIME_FORMATTER));
        ruleDto.setType(logType);
        LOGGER.info(JSON.toJSONString(ruleDto));
    }

    private BaseInnerLog() {
        // 不可实例化类
    }

}
